/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.cond.OpChannelCond;
import com.thebeastshop.pegasus.merchandise.dao.OpChannelMapper;
import com.thebeastshop.pegasus.merchandise.domain.ChannelSelector;
import com.thebeastshop.pegasus.merchandise.domain.OpChannelDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpChnCanSaleProdDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.AbstractBaseDomain;
import com.thebeastshop.pegasus.merchandise.domain.impl.ChannelSelectorImpl;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.model.OpChannel;
import com.thebeastshop.pegasus.merchandise.model.OpChannelExample;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="opChannelDomain")
public class OpChannelDomainImpl
extends AbstractBaseDomain<OpChannelVO, OpChannel>
implements OpChannelDomain {
    @Autowired
    private OpChannelMapper opChannelMapper;
    @Autowired
    private OpChnCanSaleProdDomain opChnCanSaleProdDomain;

    @Override
    public List<OpChannel> findChannelByCond(String cond) {
        OpChannelExample example = new OpChannelExample();
        example.createCriteria().andCodeLike(SQLUtils.allLike((String)cond));
        example.or().andNameLike(SQLUtils.allLike((String)cond));
        example.setOrderByClause("CODE limit 20");
        return this.opChannelMapper.selectByExample(example);
    }

    @Override
    public boolean create(OpChannel channel) {
        channel.setCreateTime(DateUtil.getNow());
        try {
            this.opChannelMapper.insert(channel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperationException("OP1003", "\u6e20\u9053\u65b0\u589e\u51fa\u9519\uff01");
        }
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("id", channel.getId());
        params.put("type", channel.getChannelType());
        String code = CodeGenerator.getInstance().generate("OP_CHANNEL_CODE", params);
        channel.setCode(code);
        this.validateCode(channel.getCode(), channel.getId());
        return this.update(channel);
    }

    @Override
    public boolean update(OpChannel channel) {
        return this.opChannelMapper.updateByPrimaryKeySelective(channel) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        this.validateDelete(id);
        return this.opChannelMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public OpChannel findById(Long id) {
        return this.opChannelMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<OpChannel> findByCriteria(OpChannelCond cond) {
        String code;
        OpChannelExample example = new OpChannelExample();
        OpChannelExample.Criteria criteria = example.createCriteria();
        String name = cond.getName();
        if (StringUtils.isNotBlank((String)name)) {
            criteria.andNameLike(SQLUtils.allLike((String)name));
        }
        if (StringUtils.isNotBlank((String)(code = cond.getCode()))) {
            criteria.andCodeLike(SQLUtils.allLike((String)code));
        }
        example.setOrderByClause(" ID " + cond.getCriteriaStr());
        int channelType = (Integer)NumberUtil.avoidNull((Number)cond.getChannelType(), (Number)-1);
        if (channelType > -1) {
            criteria.andChannelTypeEqualTo(channelType);
        }
        return this.opChannelMapper.selectByExample(example);
    }

    @Override
    public OpChannel findByCode(String code) {
        OpChannelExample example = new OpChannelExample();
        OpChannelExample.Criteria criteria = example.createCriteria();
        criteria.andCodeEqualTo(code);
        List<OpChannel> channels = this.opChannelMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(channels)) {
            return null;
        }
        return channels.get(0);
    }

    @Override
    public List<OpChannel> findAll() {
        OpChannelExample example = new OpChannelExample();
        OpChannelExample.Criteria criteria = example.createCriteria();
        List<OpChannel> channels = this.opChannelMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(channels)) {
            return Collections.emptyList();
        }
        return channels;
    }

    private void validateCode(String code, long id) {
        OpChannel channel = this.findByCode(code);
        if (channel != null && channel.getId() != id) {
            throw new OperationException("OP1001", "\u6e20\u9053\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }

    private void validateDelete(Long id) {
        OpChannel channel = this.findById(id);
        List<OpChnCanSaleProd> skus = null;
        try {
            skus = this.opChnCanSaleProdDomain.findByChannelCode(channel.getCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            throw new OperationException("OP1004", "\u6e20\u9053\u6709\u53ef\u552eSKU\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
    }

    @Override
    public List<OpChannel> selectAllFlowerShops() {
        return this.opChannelMapper.selectAllFlowerShops();
    }

    @Override
    public List<OpChannel> findChannelByType(int type) {
        return this.opChannelMapper.selectChannelByType(type);
    }

    @Override
    public List<ChannelSelector> findByChannelType(Integer type) {
        OpChannelExample example = new OpChannelExample();
        if (null != type) {
            example.createCriteria().andChannelTypeEqualTo(type);
        }
        List<OpChannel> list = this.opChannelMapper.selectByExample(example);
        return OpChannelDomainImpl.convert2ChannelSelectorList(list);
    }

    public static ChannelSelector convert2ChannleSelector(OpChannel opChannel) {
        ChannelSelectorImpl domain = new ChannelSelectorImpl();
        domain.setCode(opChannel.getCode());
        domain.setName(opChannel.getName());
        return domain;
    }

    public static List<ChannelSelector> convert2ChannelSelectorList(List<OpChannel> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (OpChannel entity : entities) {
            list.add(OpChannelDomainImpl.convert2ChannleSelector(entity));
        }
        return list;
    }
}

