/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.CampaignESClient;
import com.thebeastshop.pegasus.merchandise.client.ElasticsearchClientFactory;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;

public class SpvESClient
extends AbstractESClient<PsSpvVO> {
    @Autowired
    private CampaignESClient campaignClient;

    public SpvESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsSpvVO build(SearchHit hit, String chnCode) {
        Map params = hit.getSource();
        PsSpvVO spvVO = new PsSpvVO();
        this.buildSpv(params, spvVO);
        return spvVO;
    }

    public void buildSpv(Map<String, Object> params, PsSpvVO spvVO) {
        Integer combined;
        List attributeValuePairList;
        Integer minAmount;
        spvVO.setSpvId(MapUtils.getLong(params, (Object)"spvId"));
        spvVO.setProductId(MapUtils.getLong(params, (Object)"productId"));
        spvVO.setProductCode(MapUtils.getString(params, (Object)"prodCode"));
        if (MapUtils.getString(params, (Object)"salesPrice") != null) {
            spvVO.setSalesPrice(new BigDecimal(MapUtils.getString(params, (Object)"salesPrice")));
        }
        if ((minAmount = MapUtils.getInteger(params, (Object)"minAmount")) != null && minAmount < 1) {
            minAmount = 1;
        }
        spvVO.setMinAmount(minAmount);
        String attrs = MapUtils.getString(params, (Object)"attrs");
        if (StringUtils.isNotEmpty((String)attrs)) {
            spvVO.setAttrs(attrs);
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONArray.parseArray((String)attrs);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (jsonArray != null) {
                LinkedHashMap<Long, Long> attrValues = new LinkedHashMap<Long, Long>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONArray attrArr = jsonArray.getJSONArray(i);
                    if (attrArr.size() < 2) continue;
                    attrValues.put(attrArr.getLong(0), attrArr.getLong(1));
                }
                spvVO.setAttrValues(attrValues);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(attributeValuePairList = (List)params.get("attributeValuePairList")))) {
            ArrayList<PsAttributeValuePairVO> pairVOs = new ArrayList<PsAttributeValuePairVO>();
            for (Map attributeValue : attributeValuePairList) {
                PsAttributeValuePairVO pair = new PsAttributeValuePairVO();
                pair.setAttrId(MapUtils.getLong((Map)attributeValue, (Object)"attrId"));
                Integer combined2 = MapUtils.getInteger((Map)attributeValue, (Object)"combined");
                if (combined2 == null) {
                    combined2 = 0;
                }
                pair.setCombined(Boolean.valueOf(combined2 != 0));
                pair.setGroupName(MapUtils.getString((Map)attributeValue, (Object)"groupName"));
                pair.setAttrName(MapUtils.getString((Map)attributeValue, (Object)"attrName"));
                pair.setAttrValueId(MapUtils.getLong((Map)attributeValue, (Object)"attrValueId"));
                pair.setValue(MapUtils.getString((Map)attributeValue, (Object)"value"));
                pairVOs.add(pair);
            }
            spvVO.setAttributeValuePairList(pairVOs);
        }
        if ((combined = MapUtils.getInteger(params, (Object)"combined")) == null) {
            combined = 0;
        }
        spvVO.setCombined(Boolean.valueOf(combined != 0));
        if (combined == 0) {
            spvVO.setSkuCode(MapUtils.getString(params, (Object)"skuCode"));
        } else {
            List skuCombinationList = (List)params.get("skuCombinationList");
            if (CollectionUtils.isNotEmpty((Collection)skuCombinationList)) {
                ArrayList<PsSkuCombinationVO> skuCombinationVOs = new ArrayList<PsSkuCombinationVO>();
                for (Map skuCombination : skuCombinationList) {
                    PsSkuCombinationVO skuCombinationVO = new PsSkuCombinationVO();
                    skuCombinationVO.setSubSkuCode(MapUtils.getString((Map)skuCombination, (Object)"subSkuCode"));
                    skuCombinationVO.setQuantity(MapUtils.getInteger((Map)skuCombination, (Object)"quantity"));
                    skuCombinationVOs.add(skuCombinationVO);
                }
                spvVO.setSkuCombinationList(skuCombinationVOs);
            }
        }
        List campaignList = (List)params.get("campaignList");
        if (CollectionUtils.isNotEmpty((Collection)campaignList)) {
            ArrayList spvCampaignList = Lists.newArrayList();
            for (Map campaign : campaignList) {
                PsCampaignVO campaignVO = new PsCampaignVO();
                this.campaignClient.buildCampaign(campaign, campaignVO);
                spvCampaignList.add(campaignVO);
            }
            spvVO.setCampaignList((List)spvCampaignList);
        }
    }

    @Override
    public PsSpvVO build(SearchHit hit, String chnCode, Long total) {
        PsSpvVO spvVO = this.build(hit, chnCode);
        return spvVO;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSpvVO vo) {
        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return "spvId";
    }
}

