/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.client.CampaignESClient;
import com.thebeastshop.pegasus.merchandise.client.ElasticsearchClientFactory;
import com.thebeastshop.pegasus.merchandise.client.SpvESClient;
import com.thebeastshop.pegasus.merchandise.conf.LuhanConfig;
import com.thebeastshop.pegasus.merchandise.constants.SearchType;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValueVO;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsChnProdSaleSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsChnStockVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDeliveryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsDynmContentVO;
import com.thebeastshop.pegasus.merchandise.vo.PsLabelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.PsTagVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductClient
extends AbstractESClient<PsProductVO> {
    @Autowired
    private SpvESClient spvClient;
    @Autowired
    private CampaignESClient campaignClient;
    @Autowired
    private LuhanConfig luhanConfig;

    public ProductClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsProductVO build(SearchHit hit, String chnCode) {
        return this.build(hit, chnCode, null);
    }

    @Override
    public PsProductVO build(SearchHit hit, String chnCode, Long total) {
        List campaignList;
        List stocks;
        List channelProdInfo;
        List brands;
        List labels;
        List psTags;
        List frontCategoriesMap;
        List chnCanSeeSKu;
        List chnCanSaleSKu;
        List selfDeliveries;
        PsProductVO vo = new PsProductVO();
        Map params = hit.getSource();
        vo.setId(MapUtils.getString((Map)params, (Object)"id"));
        vo.setCode((String)params.get("code"));
        Integer isDiscount = MapUtils.getInteger((Map)params, (Object)"isDiscount");
        if (params.get("isDiscount") != null) {
            vo.setIsDiscount((Integer)params.get("isDiscount"));
        } else {
            vo.setIsDiscount(Integer.valueOf(0));
        }
        Integer prodCombined = MapUtils.getInteger((Map)params, (Object)"combined");
        if (prodCombined == null) {
            prodCombined = 0;
        }
        vo.setCombined(Boolean.valueOf(prodCombined != 0));
        String listPriceStr = MapUtils.getString((Map)params, (Object)"listPrice");
        if (listPriceStr != null) {
            vo.setListPrice(new BigDecimal(listPriceStr));
        }
        List listPriceList = (List)params.get("listPriceList");
        HashMap listPriceMap = new HashMap();
        if (listPriceList != null && chnCode != null) {
            for (Map map : listPriceList) {
                BigDecimal chnListPrice;
                String listPriceChnCode = MapUtils.getString((Map)map, (Object)"chnCode");
                String price = MapUtils.getString((Map)map, (Object)"listMap");
                if (!StringUtils.isNotEmpty((String)listPriceChnCode) || !StringUtils.isNotEmpty((String)price) || !chnCode.equals(listPriceChnCode) || (chnListPrice = new BigDecimal(price)).equals(BigDecimal.ZERO)) continue;
                vo.setListPrice(chnListPrice);
            }
        }
        vo.setAllowVipDiscount((Integer)params.get("allowVipDiscount"));
        if (params.get("allowBdDiscount") == null) {
            vo.setAllowBdDiscount(Integer.valueOf(1));
        } else {
            vo.setAllowBdDiscount((Integer)params.get("allowBdDiscount"));
        }
        vo.setAllowNoteCard((Integer)params.get("allowNoteCard"));
        vo.setPrepareDays((Integer)params.get("prepareDays"));
        vo.setSelectDeliveryDays((Integer)params.get("selectDeliveryDays"));
        vo.setPicList((String)params.get("picList"));
        vo.setPicDetail((String)params.get("picDetail"));
        vo.setPicDetailMul((String)params.get("picDetailMul"));
        vo.setPicThumb((String)params.get("picThumb"));
        vo.setName((String)params.get("name"));
        vo.setNameCn((String)params.get("nameCn"));
        Integer crossBorderFlag = MapUtils.getInteger((Map)params, (Object)"crossBorderFlag");
        vo.setCrossBorderFlag(crossBorderFlag);
        vo.setSkuCategoryDesc((String)params.get("skuCategoryDesc"));
        vo.setUpdateTime((String)params.get("updateTime"));
        vo.setCategoryId(Long.valueOf((long)(params.get("categoryId") == null ? Integer.valueOf(0) : params.get("categoryId")).intValue() + 0L));
        vo.setCategoryCode((String)ObjectUtils.defaultIfNull(params.get("categoryCode"), (Object)""));
        vo.setExpressType(params.get("expressType") == null ? Integer.valueOf(3) : params.get("expressType"));
        vo.setSkuCodes((List)params.get("skuCodes"));
        vo.setChnSaleChnCodes((List)params.get("chnSaleChnCodes"));
        vo.setOnShelfChnCodes((List)params.get("onShelfChnCodes"));
        vo.setOffShelfChnCodes((List)params.get("offShelfChnCodes"));
        vo.setSmallIconList((List)params.get("smallIconList"));
        vo.setLargeIconList((List)params.get("largeIconList"));
        vo.setIsMonthSend((Integer)params.get("isMonthSend"));
        vo.setCopywriter((String)params.get("copywriter"));
        vo.setVideo((String)params.get("video"));
        vo.setVideoCover((String)params.get("videoCover"));
        this.luhanConfig.setupProd(vo);
        vo.setAttributeList(this.buildAttributeList(params));
        vo.setSpvList(this.buildSpvList(params, Long.valueOf(vo.getId())));
        if (params.get("listPriceSpvId") != null) {
            vo.setListPriceSpvId(Long.valueOf(((Integer)params.get("listPriceSpvId")).intValue()));
        }
        vo.setTotal(total);
        vo.setSeq(Integer.valueOf(params.get("seq") == null ? 9999 : (Integer)params.get("seq")));
        vo.setDescription(MapUtils.getString((Map)params, (Object)"description"));
        Integer sort1 = (Integer)params.get("sort1");
        Integer sort2 = (Integer)params.get("sort2");
        if (sort1 == null) {
            sort1 = 99999;
        }
        if (sort2 == null) {
            sort2 = 99999;
        }
        vo.setSort1(sort1);
        vo.setSort2(sort2);
        List contents = (List)params.get("dynmContents");
        if (CollectionUtils.isNotEmpty((Collection)contents)) {
            ArrayList<PsDynmContentVO> dynmContentVOs = new ArrayList<PsDynmContentVO>(contents.size());
            for (Map content : contents) {
                PsDynmContentVO contentVO = new PsDynmContentVO();
                contentVO.setTitleCn((String)content.get("titleCn"));
                contentVO.setTitleEn((String)content.get("titleEn"));
                contentVO.setContent((String)content.get("content"));
                contentVO.setContentType((String)content.get("contentType"));
                contentVO.setSort((Integer)content.get("sort"));
                dynmContentVOs.add(contentVO);
            }
            vo.setDynmContents(dynmContentVOs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(selfDeliveries = (List)params.get("selfDeliveries")))) {
            ArrayList<PsDeliveryVO> deliveryVOs = new ArrayList<PsDeliveryVO>(selfDeliveries.size());
            for (Map deliver : selfDeliveries) {
                PsDeliveryVO deliveryVO = new PsDeliveryVO();
                deliveryVO.setDistrictId((String)deliver.get("districtId"));
                deliveryVO.setDistrictName((String)deliver.get("districtName"));
                deliveryVOs.add(deliveryVO);
            }
            vo.setSelfDeliveries(deliveryVOs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(chnCanSaleSKu = (List)params.get("chnCanSaleSKu")))) {
            ArrayList<PsChnProdSaleSkuVO> canSaleSku = new ArrayList<PsChnProdSaleSkuVO>(chnCanSaleSKu.size());
            for (Map deliver : chnCanSaleSKu) {
                PsChnProdSaleSkuVO deliveryVO = new PsChnProdSaleSkuVO();
                deliveryVO.setChnCode((String)deliver.get("chnCode"));
                deliveryVO.setCanSkus((List)deliver.get("canSkus"));
                canSaleSku.add(deliveryVO);
            }
            vo.setChnCanSaleSKu(canSaleSku);
        }
        if (CollectionUtils.isNotEmpty((Collection)(chnCanSeeSKu = (List)params.get("chnCanSeeSKu")))) {
            ArrayList<PsChnProdSaleSkuVO> canSeeSku = new ArrayList<PsChnProdSaleSkuVO>(chnCanSaleSKu.size());
            for (Map deliver : chnCanSeeSKu) {
                PsChnProdSaleSkuVO deliveryVO = new PsChnProdSaleSkuVO();
                deliveryVO.setChnCode((String)deliver.get("chnCode"));
                deliveryVO.setCanSkus((List)deliver.get("canSkus"));
                canSeeSku.add(deliveryVO);
            }
            vo.setChnCanSeeSKu(canSeeSku);
        }
        if (CollectionUtils.isNotEmpty((Collection)(frontCategoriesMap = (List)params.get("frontCategories")))) {
            ArrayList<PsCategoryVO> frontCategories = new ArrayList<PsCategoryVO>(frontCategoriesMap.size());
            for (Map category : frontCategoriesMap) {
                PsCategoryVO psCategoryVO = new PsCategoryVO();
                psCategoryVO.setCategoryCode((String)category.get("categoryCode"));
                psCategoryVO.setCategoryFullName((String)category.get("categoryFullName"));
                if (category.get("sort1") != null) {
                    psCategoryVO.setSort1((Integer)category.get("sort1"));
                }
                if (category.get("sort2") != null) {
                    psCategoryVO.setSort2((Integer)category.get("sort2"));
                }
                if (category.get("categoryId") != null) {
                    psCategoryVO.setCategoryId(Long.valueOf(String.valueOf(category.get("categoryId"))));
                }
                psCategoryVO.setCategoryName((String)category.get("categoryName"));
                frontCategories.add(psCategoryVO);
            }
            vo.setFrontCategories(frontCategories);
        }
        if (CollectionUtils.isNotEmpty((Collection)(psTags = (List)params.get("psTags")))) {
            ArrayList<PsTagVO> tagVOs = new ArrayList<PsTagVO>(psTags.size());
            for (Map content : psTags) {
                PsTagVO contentVO = new PsTagVO();
                contentVO.setIcon((String)content.get("icon"));
                contentVO.setText((String)content.get("text"));
                tagVOs.add(contentVO);
            }
            vo.setPsTags(tagVOs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(labels = (List)params.get("labels")))) {
            ArrayList<PsLabelVO> labelVOs = new ArrayList<PsLabelVO>(labels.size());
            for (Map content : labels) {
                PsLabelVO labelVO = new PsLabelVO();
                labelVO.setLabelNameCN((String)content.get("labelNameCn"));
                labelVO.setLabelName((String)content.get("labelName"));
                labelVO.setLabelId(Long.valueOf(String.valueOf(content.get("labelId"))));
                labelVOs.add(labelVO);
            }
            vo.setLabels(labelVOs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(brands = (List)params.get("brandList")))) {
            ArrayList<PsBrandVO> brandVOs = new ArrayList<PsBrandVO>(brands.size());
            for (Map content : brands) {
                PsBrandVO brandVO = new PsBrandVO();
                brandVO.setBrandCountryName((String)content.get("brandCountryName"));
                brandVO.setBrandCountryId(Long.valueOf(String.valueOf(content.get("brandCountryId"))));
                brandVO.setBrandNameCN((String)content.get("brandNameCN"));
                brandVO.setBrandName((String)content.get("brandName"));
                brandVO.setBrandId(Long.valueOf(String.valueOf(content.get("brandId"))));
                if (content.get("authLetter") != null) {
                    brandVO.setAuthLetter(Long.valueOf(String.valueOf(content.get("authLetter"))));
                }
                brandVOs.add(brandVO);
            }
            if ("PROD001018731".equals(vo.getCode()) && CollectionUtils.isNotEmpty(brandVOs)) {
                ((PsBrandVO)brandVOs.get(0)).setBrandName("BLEU BLEUET");
                ((PsBrandVO)brandVOs.get(0)).setBrandNameCN("BLEU BLEUET");
            }
            if ("PROD001018837".equals(vo.getCode()) && CollectionUtils.isNotEmpty(brandVOs)) {
                ((PsBrandVO)brandVOs.get(0)).setBrandName("THE BEAST");
                ((PsBrandVO)brandVOs.get(0)).setBrandNameCN("THE BEAST");
            }
            if ("PROD001019741".equals(vo.getCode()) && CollectionUtils.isNotEmpty(brandVOs)) {
                ((PsBrandVO)brandVOs.get(0)).setBrandName("\u838e\u90a6\u59ae\u548c\u83b7\u5609");
                ((PsBrandVO)brandVOs.get(0)).setBrandNameCN("\u838e\u90a6\u59ae\u548c\u83b7\u5609");
            }
            vo.setBrands(brandVOs);
        }
        if (CollectionUtils.isNotEmpty((Collection)(channelProdInfo = (List)params.get("channelProdInfo")))) {
            ArrayList chanProds = new ArrayList(channelProdInfo.size());
            for (Map content : channelProdInfo) {
                HashMap codeTime = new HashMap();
                codeTime.put("channelCode", content.get("channelCode"));
                codeTime.put("createTime", content.get("createTime"));
                chanProds.add(codeTime);
            }
            vo.setChannelProdInfo(chanProds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(stocks = (List)params.get("stocks")))) {
            ArrayList<PsChnStockVO> stockList = new ArrayList<PsChnStockVO>(stocks.size());
            for (Map stockMap : stocks) {
                stockList.add(new PsChnStockVO((String)stockMap.get("chnCode"), MapUtils.getInteger((Map)stockMap, (Object)"stock"), MapUtils.getInteger((Map)stockMap, (Object)"soldOut")));
            }
            vo.setStocks(stockList);
        }
        if (EmptyUtil.isNotEmpty((List)(campaignList = (List)params.get("campaignList")))) {
            ArrayList<PsCampaignVO> campaigns = new ArrayList<PsCampaignVO>();
            vo.setCampaignList(campaigns);
            for (Map campaign : campaignList) {
                PsCampaignVO psCampaignVO = new PsCampaignVO();
                this.campaignClient.buildCampaign(campaign, psCampaignVO);
                campaigns.add(psCampaignVO);
            }
        }
        return vo;
    }

    public List<PsAttributeVO> buildAttributeList(Map params) {
        List attributeList = (List)params.get("attributeList");
        ArrayList<PsAttributeVO> attributeVOs = null;
        if (CollectionUtils.isNotEmpty((Collection)attributeList)) {
            attributeVOs = new ArrayList<PsAttributeVO>();
            for (Map attribute : attributeList) {
                PsAttributeVO attributeVO = new PsAttributeVO();
                attributeVO.setAttrId(MapUtils.getLong((Map)attribute, (Object)"id"));
                attributeVO.setGroupName(MapUtils.getString((Map)attribute, (Object)"groupName"));
                attributeVO.setName(MapUtils.getString((Map)attribute, (Object)"attrName"));
                Integer combined = MapUtils.getInteger((Map)attribute, (Object)"combined");
                if (combined == null) {
                    combined = 0;
                }
                attributeVO.setCombined(Boolean.valueOf(combined != 0));
                List attributeValueList = (List)attribute.get("valueList");
                if (CollectionUtils.isNotEmpty((Collection)attributeValueList)) {
                    ArrayList<PsAttributeValueVO> attributeValueVOs = new ArrayList<PsAttributeValueVO>();
                    LinkedHashMap<String, PsAttributeValueVO> attributeValueVOMap = new LinkedHashMap<String, PsAttributeValueVO>();
                    for (Map attributeValue : attributeValueList) {
                        PsAttributeValueVO attributeValueVO = new PsAttributeValueVO();
                        attributeValueVO.setId(MapUtils.getLong((Map)attributeValue, (Object)"id"));
                        String value = MapUtils.getString((Map)attributeValue, (Object)"value");
                        Integer quantity = MapUtils.getInteger((Map)attributeValue, (Object)"quantity");
                        attributeValueVO.setValue(value);
                        attributeValueVO.setQuantity(quantity);
                        attributeValueVOs.add(attributeValueVO);
                        attributeValueVOMap.put(value, attributeValueVO);
                    }
                    attributeVO.setAttributeValueMap(attributeValueVOMap);
                    attributeVO.setAttributeValues(attributeValueVOs);
                }
                attributeVOs.add(attributeVO);
            }
        }
        return attributeVOs;
    }

    public List<PsSpvVO> buildSpvList(Map params, Long productId) {
        List spvs = (List)params.get("spvList");
        ArrayList<PsSpvVO> spvVOs = null;
        if (CollectionUtils.isNotEmpty((Collection)spvs)) {
            spvVOs = new ArrayList<PsSpvVO>(spvs.size());
            for (Map spv : spvs) {
                PsSpvVO spvVO = new PsSpvVO();
                this.spvClient.buildSpv(spv, spvVO);
                spvVOs.add(spvVO);
            }
        }
        return spvVOs;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsProductVO vo) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            Date zeroDate = DateUtil.parse((String)"0000-00-00", (String)"yyyy-MM-dd");
            Integer sort1 = vo.getSort1();
            Integer sort2 = vo.getSort2();
            builder.startObject().field("id", vo.getId()).field("type", "string").field("prodId", vo.getId()).field("type", "string").field("code", vo.getCode()).field("type", "string").field("listPrice", vo.getListPrice().doubleValue()).field("type", "double").field("allowVipDiscount", vo.getAllowVipDiscount()).field("type", "int").field("allowNoteCard", vo.getAllowNoteCard()).field("type", "int").field("prepareDays", vo.getPrepareDays()).field("type", "int").field("selectDeliveryDays", vo.getSelectDeliveryDays()).field("type", "int").field("picList", vo.getPicList()).field("type", " string").field("picDetail", vo.getPicDetail()).field("type", " string").field("picDetailMul", vo.getPicDetailMul()).field("type", " string").field("picThumb", vo.getPicThumb()).field("type", " string").field("name", vo.getName()).field("type", " string").field("nameCn", vo.getNameCn()).field("type", " string").field("skuCategoryDesc", vo.getSkuCategoryDesc()).field("type", " string").field("updateTime", vo.getUpdateTime()).field("type", " string").field("chnSaleChnCodes", (Iterable)vo.getChnSaleChnCodes()).field("type", "list").field("onShelfChnCodes", (Iterable)vo.getOnShelfChnCodes()).field("type", "list").field("offShelfChnCodes", (Iterable)vo.getOffShelfChnCodes()).field("type", "list").field("smallIconList", (Iterable)vo.getSmallIconList()).field("type", "list").field("largeIconList", (Iterable)vo.getLargeIconList()).field("type", "list").field("updateTime", this.getNow()).field("type", "string").field("updateLong", DateUtil.getNow().getTime()).field("categoryId", (Object)NumberUtil.avoidNull((Number)vo.getCategoryId(), (Number)0)).field("categoryCode", vo.getCategoryCode() == null ? "" : vo.getCategoryCode()).field("expressType", vo.getExpressType() == null ? 3 : vo.getExpressType()).field("seq", vo.getSeq() == null ? 9999 : vo.getSeq()).field("type", "int").field("sort1", sort1).field("type", "int").field("sort2", sort2).field("type", "int").field("saleStartDate", vo.getSaleStartDate()).field("type", "date").field("skuCodes", (Iterable)vo.getSkuCodes()).field("description", vo.getDescription());
            builder.startArray("selfDeliveries");
            for (PsDeliveryVO psDeliveryVO : vo.getSelfDeliveries()) {
                builder.startObject();
                builder.field("districtId", psDeliveryVO.getDistrictId());
                builder.field("districtName", psDeliveryVO.getDistrictName());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("dynmContents");
            for (PsDynmContentVO psDynmContentVO : vo.getDynmContents()) {
                builder.startObject();
                builder.field("titleCn", psDynmContentVO.getTitleCn());
                builder.field("titleEn", psDynmContentVO.getTitleEn());
                builder.field("contentType", psDynmContentVO.getContentType());
                builder.field("sort", psDynmContentVO.getSort());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("chnCanSaleSKu");
            for (PsDynmContentVO psDynmContentVO : vo.getChnCanSaleSKu()) {
                builder.startObject();
                builder.field("chnCode", psDynmContentVO.getChnCode());
                builder.field("canSkus", (Iterable)psDynmContentVO.getCanSkus());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("chnCanSeeSKu");
            for (PsDynmContentVO psDynmContentVO : vo.getChnCanSeeSKu()) {
                List canSkus = psDynmContentVO.getCanSkus();
                if (canSkus == null || canSkus.isEmpty()) continue;
                builder.startObject();
                builder.field("chnCode", psDynmContentVO.getChnCode());
                builder.field("canSkus", (Iterable)canSkus);
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("frontCategoryList");
            if (vo.getFrontCategories() == null) {
                vo.setFrontCategories(new ArrayList());
            }
            for (PsCategoryVO categoryVO : vo.getFrontCategories()) {
                builder.startObject();
                builder.field("categoryId", categoryVO.getCategoryId());
                builder.field("categoryCode", categoryVO.getCategoryCode());
                builder.field("categoryName", categoryVO.getCategoryName());
                builder.field("categoryFullName", categoryVO.getCategoryFullName());
                builder.field("sort1", categoryVO.getSort1());
                builder.field("sort2", categoryVO.getSort2());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("stocks");
            if (vo.getStocks() == null) {
                vo.setStocks(new ArrayList());
            }
            for (PsChnStockVO stockVO : vo.getStocks()) {
                builder.startObject();
                builder.field("chnCode", stockVO.getChnCode());
                builder.field("stock", stockVO.getStock());
                builder.field("soldOut", stockVO.getSoldOut());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("psTags");
            if (vo.getPsTags() == null) {
                vo.setPsTags(new ArrayList());
            }
            for (PsTagVO tagVO : vo.getPsTags()) {
                builder.startObject();
                builder.field("icon", tagVO.getIcon());
                builder.field("text", tagVO.getText());
                builder.endObject();
            }
            builder.endArray();
            builder.startArray("channelProdInfo");
            if (vo.getChannelProdInfo() == null) {
                vo.setChannelProdInfo(new ArrayList());
            }
            for (Map chanProd : vo.getChannelProdInfo()) {
                builder.startObject();
                builder.field("channelCode", chanProd.get("channelCode"));
                builder.field("createTime", chanProd.get("createTime"));
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getPrimaryKeyName() {
        return "id";
    }

    @Override
    public void queryCondPrepare(BoolQueryBuilder queryBuilder, Map<String, Object> params, SearchType type) {
        String _cateCode = "categoryCodePRE";
        String cateCode = (String)ObjectUtils.defaultIfNull((Object)params.get(_cateCode), (Object)"");
        if (StringUtils.isNotBlank((String)cateCode)) {
            params.remove(_cateCode);
            this.addQueryBuilder(queryBuilder, (QueryBuilder)QueryBuilders.prefixQuery((String)"categoryCode", (String)cateCode), type);
        }
        super.queryCondPrepare(queryBuilder, params, type);
    }
}

