/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.client;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchClientFactory {
    protected static final Logger log = LoggerFactory.getLogger(ElasticsearchClientFactory.class);
    public static String CLUSTER_NAME_NULL = "null";
    private String clusterName;
    private String index;
    private String address;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Settings getSettings() {
        if (StringUtils.isEmpty((CharSequence)this.clusterName) || this.clusterName.equals(CLUSTER_NAME_NULL)) {
            return null;
        }
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("client.transport.sniff", false).build();
        return settings;
    }

    public TransportClient createClient() {
        TransportClient client = null;
        Settings settings = this.getSettings();
        if (settings != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(TransportClient.class.getName());
                Constructor<?> constructor = clazz.getDeclaredConstructor(Settings.class);
                constructor.setAccessible(true);
                client = (TransportClient)constructor.newInstance(settings);
            }
            catch (Exception e) {
                log.error("\u521b\u5efaES\u5ba2\u6237\u7aef\u5931\u8d25\uff1a" + e);
                return null;
            }
        } else {
            client = new TransportClient();
        }
        List<InetSocketTransportAddress> addressList = this.getAddressList();
        for (InetSocketTransportAddress address : addressList) {
            client.addTransportAddress((TransportAddress)address);
        }
        return client;
    }

    public List<InetSocketTransportAddress> getAddressList() {
        if (StringUtils.isBlank((CharSequence)this.address)) {
            return Lists.newArrayList();
        }
        String[] addrs = this.address.split(",");
        if (addrs.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList<InetSocketTransportAddress> list = new ArrayList<InetSocketTransportAddress>();
        for (String addr : addrs) {
            String[] parts;
            if (StringUtils.isBlank((CharSequence)addr) || (parts = addr.split(":")).length < 2) continue;
            String host = parts[0];
            String portStr = parts[1];
            Integer port = null;
            try {
                port = Integer.parseInt(portStr);
            }
            catch (Throwable th) {
                // empty catch block
            }
            if (port == null) continue;
            InetSocketTransportAddress inetSocketTransportAddress = new InetSocketTransportAddress(host, port.intValue());
            list.add(inetSocketTransportAddress);
        }
        return list;
    }
}

