/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsClPs;
import com.thebeastshop.pegasus.merchandise.service.PcsClPsService;
import com.thebeastshop.pegasus.merchandise.vo.PcsClPsVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: PcsClPsSkuServiceImpl.java, v 0.1 2015-08-07 15:25
 */
@Service
public class PcsClPsServiceImpl implements PcsClPsService {

    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    public Long findMaxId() {
        return pcsClPsDomain.findMaxId();
    }

    @Override
    public Long add(PcsClPsVO vo) {
        pcsClPsDomain.add(BeanUtil.buildFrom(vo, PcsClPs.class));
        return vo.getId();
    }

    @Override
    public int saveSkuCodeList(List<String> codeList, Integer changeSource) {
        return pcsClPsDomain.saveSkuCodeList(codeList, changeSource);
    }

    @Override
    public List<PcsClPsVO> findByMaxId(Long maxId) {
        return BeanUtil.buildListFrom(pcsClPsDomain.findByMaxId(maxId), PcsClPsVO.class);
    }

    @Override
    public boolean deleteByMaxId(Long maxId) {
        return pcsClPsDomain.deleteByMaxId(maxId);
    }
}
