package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQualifyDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualify;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuQualifyService;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

/**
 * @author Administrator
 * @version $Id: mcPcsSkuQualifyService.java
 */
@Path("/skuQualify")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuQualifyService")
public class McPcsSkuQualifyServiceImpl implements McPcsSkuQualifyService {

    @Autowired
    private PcsSkuQualifyDomain pcsSkuQualifyDomain;

    @POST
    @Override
    public Long create(PcsSkuQualifyVO vo) {
        return pcsSkuQualifyDomain.create(pcsSkuQualifyDomain.buildFromVO(vo));
    }
    
    @PUT
    @Override
    public Boolean update(PcsSkuQualifyVO vo) {
        return pcsSkuQualifyDomain.update(pcsSkuQualifyDomain.buildFromVO(vo));
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsSkuQualifyVO findById(@PathParam("id") Long id) {
    	PcsSkuQualify record = pcsSkuQualifyDomain.findById(id);
    	PcsSkuQualifyVO vo = pcsSkuQualifyDomain.buildFromModel(record);
        return vo;

    }

    @Override
    public List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond) {
        List<PcsSkuQualifyVO> recordList = pcsSkuQualifyDomain.findByCond(cond);
        return recordList;

    }

    @Override
    public List<PcsSkuQualifyVO> findByCriteria(PcsSkuQualifyCond cond) {
        List<PcsSkuQualify> recordList = pcsSkuQualifyDomain.findByCriteria(cond);
        List<PcsSkuQualifyVO> vos = new ArrayList<PcsSkuQualifyVO>(recordList.size());
        for (PcsSkuQualify record : recordList) {
        	PcsSkuQualifyVO vo = pcsSkuQualifyDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @GET
    @Path("name/{name}")
    @Override
    public PcsSkuQualifyVO findBySkuCode(@PathParam("name") String skuCode) {
        PcsSkuQualify record = pcsSkuQualifyDomain.findBySkuCode(skuCode);
        PcsSkuQualifyVO vo = pcsSkuQualifyDomain.buildFromModel(record);
        return vo;
    }

    @Override
    public List<PcsSkuQualifyVO> findByIds(List<Long> ids) {
        List<PcsSkuQualify> recordList = pcsSkuQualifyDomain.findByIds(ids);
        List<PcsSkuQualifyVO> vos = new ArrayList<>(recordList.size());
        for (PcsSkuQualify record : recordList) {
        	PcsSkuQualifyVO vo = pcsSkuQualifyDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @Override
    public Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type) {
        return pcsSkuQualifyDomain.auditSkuQualify(userId, id, isPass, type);
    }
    
    @Override
	public Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass,Integer importedType) {
    	return pcsSkuQualifyDomain.auditSkuQualify(vo, isPass,importedType);
	}
    
    @Override
    public Boolean auditSkuQualify(Long id, Boolean isPass, Integer type) {
    	return pcsSkuQualifyDomain.auditSkuQualify(id, isPass, type);
    }

    @Override
    public long countByCond(PcsSkuQualifyCond cond) {
        return pcsSkuQualifyDomain.countByCond(cond);
    }

	@Override
	public boolean createApprovalRecord(ApprovalRecordVO vo) {
		return pcsSkuQualifyDomain.createApprovalRecord(vo);
	}

	@Override
	public List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond) {
		return pcsSkuQualifyDomain.findApprovalRecordsByCond(cond);
	}

    @Override
    public long getFileCountByCond(PcsSkuQualifyCond cond) {
        return pcsSkuQualifyDomain.getFileCountByCond(cond);
    }
}
