/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCmSplService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMadeSupplerImpl.java, v 0.1 2015-08-06 13:07
 */
@Path("/sku/cm/sql")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsSkuCmSplService")
public class McPcsSkuCmSplServiceImpl implements McPcsSkuCmSplService {

    @Autowired
    private PcsSkuCmSplDomain pcsSkuCmSplDomain;

    @Override
    public Long create(PcsSkuCmSplVO record) {
        return pcsSkuCmSplDomain.create(pcsSkuCmSplDomain.buildFromVO(record));
    }

    @Override
    public boolean update(PcsSkuCmSplVO record) {
        return false;
    }

    @Override
    public PcsSkuCmSplVO findById(long id) {
        return null;
    }

    @GET
    @Path("custom_made/{id:\\d+}")
    @Override
    public List<PcsSkuCmSplVO> findBySkuCustomMadeId(@PathParam("id") long skuCustomMadeId) {
        return pcsSkuCmSplDomain.findBySkuCustomMadeId(skuCustomMadeId);
    }

    @Override
    public boolean deleteById(long id) {
        return false;
    }

}
