package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualificationDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsQualification;
import com.thebeastshop.pegasus.merchandise.service.McPcsQualificationService;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

/**
 * @author Administrator
 * @version $Id: McPcsQualificationServiceImpl.java
 */
@Path("/qualification")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsQualificationService")
public class McPcsQualificationServiceImpl implements McPcsQualificationService {

    @Autowired
    private PcsQualificationDomain pcsQualificationDomain;

    @POST
    @Override
    public Long create(PcsQualificationVO vo) {
        return pcsQualificationDomain.create(pcsQualificationDomain.buildFromVO(vo));
    }
    
    @Override
	public List<Long> createPcsQualifications(List<PcsQualificationVO> list) {
		return createPcsQualifications(list,null);
	}
    
    @Override
	public List<Long> createPcsQualifications(List<PcsQualificationVO> qualificationVOs, Long qualifyId) {
    	List<Long> ids = new ArrayList<Long>();
		for (PcsQualificationVO vo : qualificationVOs){
			if (qualifyId != null){
				vo.setQualifyId(qualifyId);
			}
			ids.add(create(vo));
		}
		return ids;
	}
    
    @DELETE
	@Override
	public int deleteById(Long id) {
		return pcsQualificationDomain.deleteByPrimaryKey(id);
	}

    @DELETE
	@Override
	public Long deleteByQualifyId(Long qualifyId) {
		return pcsQualificationDomain.deleteByQualifyId(qualifyId);
	}
	
    @PUT
    @Override
    public Boolean update(PcsQualificationVO vo) {
        return pcsQualificationDomain.update(pcsQualificationDomain.buildFromVO(vo));
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsQualificationVO findById(@PathParam("id") Long id) {
    	PcsQualification record = pcsQualificationDomain.findById(id);
    	PcsQualificationVO vo = pcsQualificationDomain.buildFromModel(record);
        return vo;

    }
    
    @GET
    @Path("{qualifyId:\\d+}")
    @Override
    public List<PcsQualificationVO> findByQualifyId(@PathParam("qualifyId") Long qualifyId) {
        List<PcsQualification> recordList = pcsQualificationDomain.findByQualifyId(qualifyId);
        List<PcsQualificationVO> vos = new ArrayList<PcsQualificationVO>(recordList.size());
        for (PcsQualification record : recordList) {
        	PcsQualificationVO vo = pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @Override
    public List<PcsQualificationVO> findByCond(PcsQualificationCond cond) {
        List<PcsQualificationVO> recordList = pcsQualificationDomain.findByCond(cond);
        return recordList;

    }

    @Override
    public List<PcsQualificationVO> findByCriteria(PcsQualificationCond cond) {
        List<PcsQualification> recordList = pcsQualificationDomain.findByCriteria(cond);
        List<PcsQualificationVO> vos = new ArrayList<PcsQualificationVO>(recordList.size());
        for (PcsQualification record : recordList) {
        	PcsQualificationVO vo = pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<PcsQualificationVO> findByIds(List<Long> ids) {
        List<PcsQualification> recordList = pcsQualificationDomain.findByIds(ids);
        List<PcsQualificationVO> vos = new ArrayList<>(recordList.size());
        for (PcsQualification record : recordList) {
        	PcsQualificationVO vo = pcsQualificationDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @GET
    @Override
    public long countByCond(PcsQualificationCond cond) {
        return pcsQualificationDomain.countByCond(cond);
    }

}
