package com.thebeastshop.pegasus.merchandise.service.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsImportDocDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDoc;
import com.thebeastshop.pegasus.merchandise.service.McPcsImportDocService;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.ws.rs.*;
import java.util.*;

@Path("/importDoc")
@Consumes({ContentType.APPLICATION_JSON_UTF_8})
@Produces({ContentType.APPLICATION_JSON_UTF_8})
@Service("mcPcsImportDocService")
public class McPcsImportDocServiceImpl implements McPcsImportDocService {

    @Autowired
    private PcsImportDocDomain pcsImportDocDomain;

    @POST
    @Override
    public Long create(PcsImportDocVO vo) {
        return pcsImportDocDomain.create(pcsImportDocDomain.buildFromVO(vo));
    }
    
    @Override
	public List<Long> createPcsImportDocs(List<PcsImportDocVO> list) {
    	List<Long> ids = new ArrayList<Long>();
    	for (PcsImportDocVO vo : list){
    		ids.add(create(vo));
    	}
		return ids;
	}

	@Override
	public boolean createPcsImportDocs(List<PcsImportDocVO> importDocVOs, Long qualifyId) {
		List<Long> ids = new ArrayList<Long>();
    	for (PcsImportDocVO vo : importDocVOs){
    		vo.setQualifyId(qualifyId);
    		ids.add(create(vo));
    	}
		return ids.size() == importDocVOs.size();
	}
    
    @DELETE
	@Override
	public int deleteById(Long id) {
		return pcsImportDocDomain.deleteByPrimaryKey(id);
	}

	@DELETE
	@Override
	public Long deleteByQualifyId(Long qualifyId) {
		return pcsImportDocDomain.deleteByQualifyId(qualifyId);
	}
	
    @PUT
    @Override
    public Boolean update(PcsImportDocVO vo) {
        return pcsImportDocDomain.update(pcsImportDocDomain.buildFromVO(vo));
    }

    @GET
    @Path("{id:\\d+}")
    @Override
    public PcsImportDocVO findById(@PathParam("id") Long id) {
    	PcsImportDoc record = pcsImportDocDomain.findById(id);
    	PcsImportDocVO vo = pcsImportDocDomain.buildFromModel(record);
        return vo;

    }
    
    @GET
    @Path("{qualifyId:\\d+}")
    @Override
    public List<PcsImportDocVO> findByQualifyId(@PathParam("qualifyId") Long qualifyId) {
        List<PcsImportDoc> recordList = pcsImportDocDomain.findByQualifyId(qualifyId);
        List<PcsImportDocVO> vos = new ArrayList<PcsImportDocVO>(recordList.size());
        for (PcsImportDoc record : recordList) {
        	PcsImportDocVO vo = pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @Override
    public List<PcsImportDocVO> findByCond(PcsImportDocCond cond) {
        List<PcsImportDocVO> recordList = pcsImportDocDomain.findByCond(cond);
        return recordList;

    }

    @Override
    public List<PcsImportDocVO> findByCriteria(PcsImportDocCond cond) {
        List<PcsImportDoc> recordList = pcsImportDocDomain.findByCriteria(cond);
        List<PcsImportDocVO> vos = new ArrayList<PcsImportDocVO>(recordList.size());
        for (PcsImportDoc record : recordList) {
        	PcsImportDocVO vo = pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;
    }

    @Override
    public List<PcsImportDocVO> findByIds(List<Long> ids) {
        List<PcsImportDoc> recordList = pcsImportDocDomain.findByIds(ids);
        List<PcsImportDocVO> vos = new ArrayList<>(recordList.size());
        for (PcsImportDoc record : recordList) {
        	PcsImportDocVO vo = pcsImportDocDomain.buildFromModel(record);
            vos.add(vo);
        }
        return vos;

    }

    @GET
    @Override
    public long countByCond(PcsImportDocCond cond) {
        return pcsImportDocDomain.countByCond(cond);
    }

}
