package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsCopywriterDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriter;
import com.thebeastshop.pegasus.merchandise.service.McPcsCopywriterService;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by QTJ on 2017/6/12.
 */
@Service("mcPcsCopywriterService")
public class McPcsCopywriterServiceImpl implements McPcsCopywriterService {

    private static Logger log = LoggerFactory.getLogger(McPcsCopywriterServiceImpl.class);

    @Autowired
    private PcsCopywriterDomain pcsCopywriterDomain;

    @Override
    public Long addCopywriter(PcsCopywriterVO copywriterVO) {
        PcsCopywriter pcsCopywriter = BeanUtil.buildFrom(copywriterVO, PcsCopywriter.class);
        pcsCopywriterDomain.addCopywriter(pcsCopywriter);
        return pcsCopywriter.getId();
    }

    @Override
    public int updateCopywriter(PcsCopywriterVO copywriterVO) {
        return pcsCopywriterDomain.updateCopywriter(copywriterVO);
    }

    @Override
    public int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate) {
        return pcsCopywriterDomain.updateProdCopywriterByCodeList(prod,copywriterCodeList,isEmptyBeforeUpdate);
    }

    @Override
    public PcsCopywriterVO findCopywriterById(Long id) {
        return pcsCopywriterDomain.findCopywriterById(id);
    }

    @Override
    public List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond) {
        return pcsCopywriterDomain.queryProdCopywriterList(cond);
    }

    @Override
    public int deleteProdCopywriterByIds(List<String> idList) {
        return pcsCopywriterDomain.deleteProdCopywriterByIds(idList);
    }

    @Override
    public List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond) {
        return pcsCopywriterDomain.queryPcsCopywriterVOListByCond(cond);
    }

    @Override
    public ProdSkuVO queryProductByProdCode(String prodCode) {
        return pcsCopywriterDomain.queryProductByProdCode(prodCode);
    }

    @Override
    public void updateCopywriterValidStatus() {
         pcsCopywriterDomain.updateCopywriterValidStatus();
    }

    @Override
    public Map<String, ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes) {
        return pcsCopywriterDomain.selectProductCopywriterByProdCodes(codes);
    }

    @Override
    public void updateActiveCopywriter() {
        pcsCopywriterDomain.updateActiveFalseCopywriter();
        pcsCopywriterDomain.updateActiveTrueCopywriter();
    }

    @Override
    public void updateValidStatus() {
        pcsCopywriterDomain.updateValidStatusPendingEffect();
        pcsCopywriterDomain.updateValidStatusAlreadyInForce();
        pcsCopywriterDomain.updateValidStatusExpired();
    }
}
