/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.domain.OpProdDynmContDomain;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmContService;
import com.thebeastshop.pegasus.merchandise.vo.OpProdDynmContVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: OpProdDynmContServiceImpl.java, v 0.1 2015-08-19 13:51
 */
@Service("mcOpProdDynmContService")
public class McOpProdDynmContServiceImpl implements McOpProdDynmContService {

    @Autowired
    private OpProdDynmContDomain opProdDynmContDomain;

    @Override
    public boolean create(OpProdDynmContVO vo) {
        return  opProdDynmContDomain.create(vo);
    }

    @Override
    public boolean update(OpProdDynmContVO vo) {
        return opProdDynmContDomain.update(vo);
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdDynmContDomain.deleteById(id);
    }

    @Override
    public List<OpProdDynmContVO> findByProdId(Long prodId) {
        return opProdDynmContDomain.findByProdId(prodId);
    }

    @Override
    public boolean createOrUpdate(List<OpProdDynmContVO> vos) {
        return opProdDynmContDomain.createOrUpdate(vos);
    }

    @Override
    public boolean deleteByProdId(Long prodId) {
        return opProdDynmContDomain.deleteByProdId(prodId);
    }

    @Override
    public int updateContentByProdIdAndType(String content, String prodId, String type) {
        return opProdDynmContDomain.updateContentByProdIdAndType(content, prodId, type);
    }

}
