/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.client.AbstractESClient;
import com.thebeastshop.pegasus.merchandise.service.BasePsService;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: BasePsServiceImpl.java, v 0.1 2015-08-19 11:08
 */
public abstract class BasePsServiceImpl<T> implements BasePsService<T> {

    @Override
    public boolean create(T vo) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return getESClient().create(vo, stackTraceElement);
    }

    @Override
    public boolean create(List<T> vos) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return getESClient().create(vos, stackTraceElement);
    }

    @Override
    public boolean createOrUpdate(T vo) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return getESClient().createOrUpdate(stackTraceElement, vo);
    }

    @Override
    public boolean createOrUpdate(List<T> vos) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        return getESClient().createOrUpdate(stackTraceElement, vos);
    }

    @Override
    public boolean update(T vo) {
        return getESClient().update(vo);
    }

    @Override
    public boolean update(List<T> vos) {
        return getESClient().update(vos);
    }

    @Override
    public boolean deleteById(String id) {
        return getESClient().deleteByPrimaryKey(id);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        return getESClient().deleteByPrimaryKey(ids);
    }

    @GET
    @Path("all")
    @Override
    public List findAll() {
        return getESClient().findAllByField(null,null);
    }



    public abstract AbstractESClient<T> getESClient();
}
