package com.thebeastshop.pegasus.merchandise.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.util.ObjUtils;

import com.thebeastshop.pegasus.merchandise.IService.IRecommendService;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.scm.dao.RecommendDao;
import com.thebeastshop.scm.dao.RecommendProductAutoDao;
import com.thebeastshop.scm.dao.RecommendProductDao;
import com.thebeastshop.scm.po.Recommend;
import com.thebeastshop.scm.po.RecommendProductAuto;
import com.thebeastshop.scm.vo.recommend.OrderFinishRecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoListVO;
import com.thebeastshop.scm.vo.recommend.RecommendAutoProdSaveVO;
import com.thebeastshop.scm.vo.recommend.RecommendEditVO;
import com.thebeastshop.scm.vo.recommend.RecommendParamVO;
import com.thebeastshop.scm.vo.recommend.RecommendSaveVO;

@Service
public class RecommendService implements IRecommendService {
	 private static final Logger log = LoggerFactory.getLogger(RecommendService.class);
	@Resource McPsProductServiceImpl mcPsProductService;
	@Resource RecommendDao recommendDao;
	@Resource RecommendProductDao recommendProductDao;
	@Resource RecommendProductAutoDao recommendProductAutoDao;
	
	@Override
	public List<Recommend> list(){
		return recommendDao.findAll();
	}
	
	@Override
	public void save(RecommendSaveVO vo) {
		Recommend recommend = vo.toRecommend();
		recommendDao.saveByPosition(recommend);
		recommendProductDao.save(vo.getProductCode(), recommend.getId());
	}
	
	@Override
	public void saveAutoProd(RecommendAutoProdSaveVO vo) {
		List<RecommendProductAuto> list = vo.toRecommendAutoProdList();
		recommendProductAutoDao.save(vo.getPosition(), vo.getSourceProductCode(), list);
	}
	
	@Override
	public List<RecommendAutoListVO> autoList(RecommendProductAuto.Position Position, RecommendProductAuto.Type type, String sourceProductCode) {
		List<RecommendProductAuto> recommendProductAutoList = recommendProductAutoDao.autoList(Position.toString(), type.toString(), sourceProductCode);
		List<RecommendAutoListVO> result = new ArrayList<RecommendAutoListVO>();
		for (RecommendProductAuto recommendProductAuto : recommendProductAutoList) {
			PsProductVO psProductVO = mcPsProductService.findProdByCode(recommendProductAuto.getRecommendProductCode());
			RecommendAutoListVO recommendAutoListVO = new RecommendAutoListVO();
			String brandNameCn = "", categoryName = "";
			PsBrandVO psBrandVO = ObjUtils.get(psProductVO.getBrands(), 0);
			if (psBrandVO != null) {
				brandNameCn = psBrandVO.getBrandNameCN();
			}
			PsCategoryVO psCategoryVO = ObjUtils.get(psProductVO.getFrontCategories(), 0);
			if (psCategoryVO != null) {
				categoryName = psCategoryVO.getCategoryFullName();
			}
			recommendAutoListVO.setBrandNameCn(brandNameCn);
			recommendAutoListVO.setCategoryName(categoryName);
			recommendAutoListVO.setCode(psProductVO.getCode());
			recommendAutoListVO.setId(recommendProductAuto.getId());
			recommendAutoListVO.setNameCn(psProductVO.getNameCn());
			recommendAutoListVO.setSalesPrice(psProductVO.getListPrice());
			recommendAutoListVO.setSort(recommendProductAuto.getSort());
			recommendAutoListVO.setStatus(recommendProductAuto.getStatus());
			result.add(recommendAutoListVO);
		}
		return result;
	}
	
	private final String APP_CHANNEL_CODE = "CHN2049";
	
	/**
	 * 免邮凑单：售价小于99的所有prod，按价格由低到高排序
	 */
	@Override
	public List<RecommendAutoListVO> addOnItemList(Integer pagenum) {
		List<PsProductVO> psProductVOList = mcPsProductService.addOnItemList(this.APP_CHANNEL_CODE, pagenum, null);
		return this.toRecommendAutoListVOByPsProductVOList(RecommendProductAuto.Position.ADD_ON_ITEM.toString(), null, psProductVOList);
	}
	
	@Override
	public List<RecommendAutoListVO> prodDetailsList(String productCode) {
		List<PsProductVO> psProductVOList= this.prodDetailsPsProductVOList(this.APP_CHANNEL_CODE, productCode, 50, null);
		return this.toRecommendAutoListVOByPsProductVOList(RecommendProductAuto.Position.PROD_DETAIL.toString(), productCode, psProductVOList);
	}
	
	@Override
	public RecommendEditVO edit(Integer recommendId) {
		Recommend recommend = recommendDao.selectOne(recommendId);
		List<Map> list = recommendProductDao.getProductListMapByRecommendId(recommendId);
		return new RecommendEditVO(recommend, list);
	}
	
	@Override
	public List<PsProductVO> getShoppingCartProcutList(RecommendParamVO paramVO){
		log.info("推荐商品 购物车入参:{}", paramVO);
		String rule = recommendDao.getRuleByCart();
		List<String> productCodeList = recommendProductDao.getProductCodeByCart(rule, 200);
		PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
		psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
		psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
		psMatchCampaignCond.setDiscount(paramVO.getDiscount());
		psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
		psMatchCampaignCond.setMatchCampaign(true);
		List<PsProductVO> productVOs = mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodeList, psMatchCampaignCond, 1, 200);
		Map<String, PsProductVO> map = new HashMap<>();
		for (PsProductVO psProductVO : productVOs) {
			map.put(psProductVO.getCode(), psProductVO);
		}
		List<PsProductVO> result = new ArrayList<PsProductVO>();
		for (String code : productCodeList) {
			PsProductVO vo = map.get(code);
			if (vo != null) {
				result.add(vo);
			}
		}
		int toIndex = result.size() < paramVO.getLimitSize() ? result.size() : paramVO.getLimitSize() ;
		return result.subList(0, toIndex);
	}

	/**
	 * 自动推荐接口得到数据
	 */
	@Override
	public List<PsProductVO> autoRecommend(RecommendParamVO paramVO) {
		log.info("自动推荐商品入参:{}", paramVO);
		PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
		psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
		psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
		psMatchCampaignCond.setDiscount(paramVO.getDiscount());
		psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
		psMatchCampaignCond.setMatchCampaign(true);
		Integer limitSize = paramVO.getLimitSize();
		List<PsProductVO> result = new ArrayList<PsProductVO>();
		//取人工推荐商品列表 和设置过排序的自动推荐商品列表数据
		List<String> productCodes = recommendProductAutoDao.getProcutCodeByPosition(paramVO.getType().toString(), paramVO.getProductCode(), limitSize);
		if (CollectionUtils.isNotEmpty(productCodes)) {
			List<PsProductVO> productVOs = mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodes, psMatchCampaignCond, 1, limitSize);
			Map<String, PsProductVO> map = new HashMap<>();
			for (PsProductVO psProductVO : productVOs) {
				map.put(psProductVO.getCode(), psProductVO);
			}
			for (String code : productCodes) {
				PsProductVO vo = map.get(code);
				if (vo != null) {
					result.add(vo);
				}
			}
		}
		
		//人工推荐数据不够,再取自动推荐商品列表(ES)30条数据
		if (result.size() < limitSize) {
			int pagenum = limitSize * 2;
			List<PsProductVO> psProductVOList = new ArrayList<>();
			if (paramVO.getType().equals(RecommendParamVO.Type.ADD_ON_ITEM)) {
				psProductVOList = mcPsProductService.addOnItemList(paramVO.getChnCode(), pagenum, psMatchCampaignCond);
			} else {
				psProductVOList = this.prodDetailsPsProductVOList(paramVO.getChnCode(), paramVO.getProductCode(), pagenum, psMatchCampaignCond);
			}
			List<PsProductVO> psProductVOCowList = new CopyOnWriteArrayList<PsProductVO>(psProductVOList);
			if (CollectionUtils.isEmpty(psProductVOCowList)) {
				return result;
			}
			List<String> maskingProductCodes = recommendProductAutoDao.getMaskingProcutCodeByPosition(RecommendProductAuto.Position.PROD_DETAIL, paramVO.getProductCode());
			for (PsProductVO psProductVO : psProductVOCowList) {
				//过滤设置为屏蔽的记录
				for (String maskingProductCode : maskingProductCodes) {
					if (psProductVO.getCode().equals(maskingProductCode)) {
						psProductVOCowList.remove(psProductVO);
					}
				}
				//过滤设置已被设置排序值的自动推荐商品列表中的记录
				for (PsProductVO productVO : result) {
					if (psProductVO.getCode().equals(productVO.getCode())) {
						psProductVOCowList.remove(psProductVO);
					}
				}
			}
			result.addAll(psProductVOCowList);
		}
		int toIndex = result.size() < limitSize ? result.size() : limitSize;
		return result.subList(0, toIndex);
	}
	
	@Override
	public List<PsProductVO> orderFinishRecommend(OrderFinishRecommendParamVO paramVO) {
		log.info("订单完成自动推荐入参:{}", paramVO);
		PsMatchCampaignCond psMatchCampaignCond = new PsMatchCampaignCond();
		psMatchCampaignCond.setAccessWay(paramVO.getAccessWay());
		psMatchCampaignCond.setMemberLevel(paramVO.getMemberLevel());
		psMatchCampaignCond.setDiscount(paramVO.getDiscount());
		psMatchCampaignCond.setBdDiscount(paramVO.getBdDiscount());
		psMatchCampaignCond.setMatchCampaign(true);
		Integer limitSize = paramVO.getLimitSize();
		List<String> productCodes = recommendProductAutoDao.getProcutCodesByProdDetail(paramVO.getProductCodes(), limitSize);
		List<PsProductVO> productVOs = mcPsProductService.findRecommondProdByCodes(paramVO.getChnCode(), productCodes, psMatchCampaignCond, 1, limitSize);
		
		Map<String, PsProductVO> map = new HashMap<>();
		for (PsProductVO psProductVO : productVOs) {
			map.put(psProductVO.getCode(), psProductVO);
		}
		List<PsProductVO> result = new CopyOnWriteArrayList<PsProductVO>();
		for (String code : productCodes) {
			PsProductVO vo = map.get(code);
			if (vo != null) {
				result.add(vo);
			}
		}
		//人工推荐数据不够,再取自动推荐商品列表(ES)的数据
		if (result.size() < limitSize) {
			int pagenum = limitSize * 2;
			List<PsProductVO> psProductVOList = this.prodDetailsPsProductVOList(paramVO.getChnCode(), paramVO.getProductCodes(), pagenum, psMatchCampaignCond);
			List<PsProductVO> psProductVOCowList = new CopyOnWriteArrayList<PsProductVO>(psProductVOList);
			if (CollectionUtils.isEmpty(psProductVOCowList)) {
				return result;
			}
			List<String> maskingProductCodes = recommendProductAutoDao.getMaskingProcutCodesByProdDetail(paramVO.getProductCodes());
			for (PsProductVO psProductVO : psProductVOCowList) {
				//过滤设置为屏蔽的记录
				for (String maskingProductCode : maskingProductCodes) {
					if (psProductVO.getCode().equals(maskingProductCode)) {
						psProductVOCowList.remove(psProductVO);
					}
				}
				//过滤设置已被设置排序值的自动推荐商品列表中的记录
				for (PsProductVO productVO : result) {
					if (psProductVO.getCode().equals(productVO.getCode())) {
						psProductVOCowList.remove(psProductVO);
					}
				}
			}
			result.addAll(psProductVOCowList);
		}
		
		//不显示源商品本身
		for (PsProductVO productVO : result) {
			for (String productCode : paramVO.getProductCodes()) {
				if (productCode.equals(productVO.getCode())) {
					result.remove(productVO);
				}
			}
		}
		
		int toIndex = result.size() < limitSize ? result.size() : limitSize;
		return result.subList(0, toIndex);
	}
	
	private List<RecommendAutoListVO> toRecommendAutoListVOByPsProductVOList(String position, String sourceProductCode, List<PsProductVO> psProductVOList){
		List<RecommendAutoListVO> result = new ArrayList<RecommendAutoListVO>();
		List<String> productCodes = new ArrayList<String>();
		for (PsProductVO psProductVO : psProductVOList) {
			productCodes.add(psProductVO.getCode());
		}
		Map<String, RecommendProductAuto> recommendProductAutoMap = recommendProductAutoDao.byRecommendProductCodes(position, sourceProductCode, productCodes);
		for (PsProductVO psProductVO : psProductVOList) {
			RecommendProductAuto recommendProductAuto = recommendProductAutoMap.get(psProductVO.getCode());
			RecommendAutoListVO recommendAutoListVO = new RecommendAutoListVO();
			//去重
			if (recommendProductAuto == null) {
				recommendAutoListVO.setStatus(1);
			} else {
				recommendAutoListVO.setStatus(recommendProductAuto.getStatus());
				recommendAutoListVO.setSort(recommendProductAuto.getSort());
				if (recommendProductAuto.getSort() != null){
					continue;
				}
			}
			String brandNameCn = "", categoryName = "";
			PsBrandVO psBrandVO = ObjUtils.get(psProductVO.getBrands(), 0);
			if (psBrandVO != null) {
				brandNameCn = psBrandVO.getBrandNameCN();
			}
			PsCategoryVO psCategoryVO = ObjUtils.get(psProductVO.getFrontCategories(), 0);
			if (psCategoryVO != null) {
				categoryName = psCategoryVO.getCategoryFullName();
			}
			recommendAutoListVO.setBrandNameCn(brandNameCn);
			recommendAutoListVO.setCategoryName(categoryName);
			recommendAutoListVO.setCode(psProductVO.getCode());
			recommendAutoListVO.setNameCn(psProductVO.getNameCn());
			recommendAutoListVO.setSalesPrice(psProductVO.getListPrice());
			
			result.add(recommendAutoListVO);
		}
		return result;
	}
	
	/**
	 * 得到商品同品牌且价格大于等于当前商品价格*0.7小于等于当前商品价格*1.3+与当前商品同二级品类且价格大于等于当前商品价格*0.7小于等于当前商品价格*1.3 按上架时间由近到远排序
	 * @param productCode
	 * @param matchCampaignCond
	 * @return
	 */
	private List<PsProductVO> prodDetailsPsProductVOList(String chnCode, String productCode, int pagenum, PsMatchCampaignCond matchCampaignCond){
		PsProductVO productVO = mcPsProductService.findProdByCode(productCode);
		Long brandId = null, categoryId = null;
		PsBrandVO psBrandVO = ObjUtils.get(productVO.getBrands(), 0);
		if (psBrandVO != null) {
			brandId = psBrandVO.getBrandId();
		}
		PsCategoryVO psCategoryVO = ObjUtils.get(productVO.getFrontCategories(), 0);
		if (psCategoryVO != null) {
			categoryId = psCategoryVO.getCategoryId();
		}
		BigDecimal big03 = productVO.getListPrice().multiply(new BigDecimal(0.3));
		int startListPrices = productVO.getListPrice().subtract(big03).intValue();
		int endListPrice = productVO.getListPrice().add(big03).intValue();
		List<PsProductVO> psProductVOList= mcPsProductService.prodDetailsList(chnCode, brandId, categoryId, startListPrices, endListPrice, pagenum, matchCampaignCond);
		//自动推荐不显示源商品本身
		for (PsProductVO psProductVO : psProductVOList) {
			if (productCode.equals(psProductVO.getCode())) {
				psProductVOList.remove(psProductVO);
				break;
			}
		}
		return psProductVOList;
	}

	private List<PsProductVO> prodDetailsPsProductVOList(String chnCode, List<String> productCodes, int pagenum, PsMatchCampaignCond matchCampaignCond){
		Set<PsProductVO> result = new HashSet<PsProductVO>();
		for (String productCode : productCodes) {
			List<PsProductVO>  list = this.prodDetailsPsProductVOList(chnCode, productCode, pagenum, matchCampaignCond);
			result.addAll(list);
		}
		return new ArrayList<PsProductVO>(result);
	}

	public static void main(String[] args) {
		List psProductVOList = null;
		List<PsProductVO> psProductVOCowList = new CopyOnWriteArrayList<PsProductVO>(psProductVOList);
	}
}