package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.IProdDynmContService;
import com.thebeastshop.pegasus.merchandise.vo.UpdateProdDynmContVO;
import com.thebeastshop.scm.dao.ProdDynmContDao;
import com.thebeastshop.scm.po.ProdDynmCont;

@Service
public class ProdDynmContService extends BaseService<ProdDynmCont> implements IProdDynmContService {

	private ProdDynmContDao prodDynmContDao;
	
	@Autowired
	public ProdDynmContService(@Qualifier("prodDynmContDao") IDao dao) {
		super(dao);
		prodDynmContDao = (ProdDynmContDao)super.dao;
	}

	@Override
	public void updateProdDynmCont(UpdateProdDynmContVO vo) {
		List<ProdDynmCont> list = vo.toProdDynmContList();
		prodDynmContDao.batchSave(list);
	}

	public void saveByProdCodeAndType(Integer productId, String content, Integer contentTypeIndex){
		prodDynmContDao.saveByProdCodeAndType(productId, content, contentTypeIndex);
	}

}
