package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.IChnCanSaleProdService;
import com.thebeastshop.scm.dao.ChnCanSaleProdDao;
import com.thebeastshop.scm.po.ChnCanSaleProd;

@Service
public class ChnCanSaleProdService extends BaseService<ChnCanSaleProd> implements IChnCanSaleProdService {

	private ChnCanSaleProdDao chnCanSaleProdDao;
	
	@Autowired
	public ChnCanSaleProdService(@Qualifier("chnCanSaleProdDao") IDao dao) {
		super(dao);
		chnCanSaleProdDao = (ChnCanSaleProdDao)super.dao;
		
	}

	public ChnCanSaleProd byChannelCodeAndProductId(String channelCode, Integer productId) {
		return chnCanSaleProdDao.byChannelCodeAndProductId(channelCode, productId);
	}

	@Override
	public List<Map> listProdUpDown(Map params) {
		return chnCanSaleProdDao.listProdUpDown(params);
	}
	

}
