package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import pers.richard.ormybatis.dao.IDao;
import pers.richard.ormybatis.service.BaseService;

import com.thebeastshop.pegasus.merchandise.IService.IBuyerInfoService;
import com.thebeastshop.scm.dao.BuyerInfoDao;
import com.thebeastshop.scm.po.BuyerInfo;

@Service
public class BuyerInfoService extends BaseService<BuyerInfo> implements IBuyerInfoService {

	private BuyerInfoDao buyerInfoDao;
	
	@Autowired
	public BuyerInfoService(@Qualifier("buyerInfoDao") IDao dao) {
		super(dao);
		buyerInfoDao = (BuyerInfoDao)super.dao;
		
	}

	@Override
	public List<BuyerInfo> findAll() {
		return buyerInfoDao.findAll();
	}
	

}
