package com.thebeastshop.pegasus.merchandise.price;

import com.thebeastshop.pegasus.merchandise.service.impl.McPsProductServiceImpl;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.List;

/**
 * 特殊SPV活动价格计算器
 * @author gongjun
 * @since 2016-12-29
 */
public class SpecialSpvPriceCalculator extends AbstractSpecialPriceCalculator implements PriceCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(McPsProductServiceImpl.class);

    private PsSpvVO spvVO;

    private PsCampaignVO campaign;

    public SpecialSpvPriceCalculator(PriceCalculator sourcePriceCalculator, PsSpvVO spvVO, PsCampaignVO campaign) {
        super(sourcePriceCalculator);
        this.spvVO = spvVO;
        this.campaign = campaign;
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
        BigDecimal targetPrice = getPrevPrice(results);
        Long campaignId = campaign.getId();
        if (spvVO.getCombined() != null && spvVO.getCombined()) {
            String skuCode = spvVO.getSkuCode();
            if (specialNum.equals(String.valueOf(campaignId))) {
                LOGGER.info("===查询商品详情SKUCODE 参数为 code= {}", skuCode);
                if (specialSkuMap.containsKey(skuCode)) {
                    LOGGER.info("===查询商品详情price 参数为 code= {}", specialSkuMap.get(skuCode));
                    targetPrice = specialSkuMap.get(skuCode);
                }
            } else if (special481Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===481查询商品详情SKUCODE 参数为 code= {}", skuCode);
                if (special481SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===481查询商品详情price 参数为 code= {}", special481SkuMap.get(skuCode));
                    targetPrice = special481SkuMap.get(skuCode);
                }
            } else if (special482Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===482查询商品详情SKUCODE 参数为 code= {}", skuCode);
                if (special482SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===482查询商品详情price 参数为 code= {}", special482SkuMap.get(skuCode));
                    targetPrice = special482SkuMap.get(skuCode);
                }
            } else if (special463Num.equals(String.valueOf(campaignId))) {
                LOGGER.info("===463查询商品详情SKUCODE 参数为 code= {}", skuCode);
                if (special463SkuMap.containsKey(skuCode)) {
                    LOGGER.info("===463查询商品详情price 参数为 code= {}", special463SkuMap.get(skuCode));
                    targetPrice = special463SkuMap.get(skuCode);
                }
            } else if (special503Num.equals(String.valueOf(campaignId))) {
                if (special503SkuMap.containsKey(skuCode)) {
                    targetPrice = special503SkuMap.get(skuCode);
                }
            } else if (special574Num.equals(String.valueOf(campaignId))) {
                if (special574SkuMap.containsKey(skuCode)) {
                    targetPrice = special574SkuMap.get(skuCode);
                }
            } else if (special590Num.equals(String.valueOf(campaignId))) {
                if (special590SkuMap.containsKey(skuCode)) {
                    targetPrice = special590SkuMap.get(skuCode);
                }
            } else if (special591Num.equals(String.valueOf(campaignId))) {
                if (special591SkuMap.containsKey(skuCode)) {
                    targetPrice = special591SkuMap.get(skuCode);
                }
            } else if (special592Num.equals(String.valueOf(campaignId))) {
                if (special592SkuMap.containsKey(skuCode)) {
                    targetPrice = special592SkuMap.get(skuCode);
                }
            } else if (special594Num.equals(String.valueOf(campaignId))) {
                if (special594SkuMap.containsKey(skuCode)) {
                    targetPrice = special594SkuMap.get(skuCode);
                }
            }
        }
        return targetPrice;
    }

}
