package com.thebeastshop.pegasus.merchandise.price;


import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.thebeastshop.pegasus.merchandise.enums.PriceCalTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PriceCalResultVO;

/**
 * 价格折扣计算器
 * @author gongjun
 * @since 2016-12-29
 */
public class DiscountPriceCalculator extends AbstractPriceCalculator implements PriceCalculator {

    // 价格因子
    protected BigDecimal factor;

    // 折扣类型
    protected Integer factorType;
    
    // 活动ID
 	protected Long campaignId;

    public DiscountPriceCalculator(PriceCalculator sourcePriceCalculator, BigDecimal factor, Integer factorType, Long campaignId) {
        super(sourcePriceCalculator);
        this.factor = factor;
        this.factorType = factorType;
        this.campaignId = campaignId; 
    }

    @Override
    public BigDecimal calculate(List<PriceCalResultVO> results) {
    	BigDecimal targetPrice = getPrevPrice(results);

    	PriceCalResultVO result = new PriceCalResultVO(); //计算价格结果
    	result.setType(PriceCalTypeEnum.CAMPAIGN);
    	result.setOriginalPrice(targetPrice);
    	result.setExtId(campaignId);
    	
        if (factor == null) {
            return targetPrice;
        }
        if (factorType == null) {
            return targetPrice;
        }
        if(factorType.equals(DiscountFactorType.DISCOUNT_PRICE.getId())
                || factorType.equals(DiscountFactorType.DIFFERENT_DISCOUNT.getId())) {
            // 是统一折扣或者不同折扣，则计算折扣价
            targetPrice = targetPrice.multiply(factor.divide(BigDecimal.TEN));
        } else if (factorType.equals(DiscountFactorType.FIXED_PRICE.getId())
                || factorType.equals(DiscountFactorType.DIFFERENT_PRICE.getId())) {
            // 是固定价格或者不同价格，直接把价格设置成固定的价格
            targetPrice = factor;
        }
        
        if(results != null){
        	// 添加计算价格结果
        	result.setFinalPrice(targetPrice);
        	results.add(result);
        }
        
        return targetPrice;
    }
}
