package com.thebeastshop.pegasus.merchandise.price;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 公用特殊活动价格计算器
 * @author gongjun
 * @since 2016-12-29
 */
public abstract class AbstractSpecialPriceCalculator extends AbstractPriceCalculator {

    protected final static String specialNum    = "462";
    protected final static String special481Num = "481";
    protected final static String special482Num = "482";
    protected final static String special463Num = "463";
    protected final static String special503Num = "503";
    protected final static String special574Num = "574";
    protected final static String special590Num = "590";
    protected final static String special591Num = "591";
    protected final static String special592Num = "592";
    protected final static String special594Num = "594";

    protected final  static Map<String,BigDecimal> specialProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> specialSkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special481ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special481SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special482ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special482SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special463ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special463SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special503ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special503SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special574ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special574SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special590ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special590SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special591ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special591SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special592ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special592SkuMap = new HashMap();
    protected final  static Map<String,BigDecimal> special594ProdMap = new HashMap();
    protected final  static Map<String,BigDecimal> special594SkuMap = new HashMap();
    static {
        specialProdMap.put("PROD001014105",new BigDecimal(499));
        specialProdMap.put("PROD001013171",new BigDecimal(499));
        specialProdMap.put("PROD001016880",new BigDecimal(499));
        specialProdMap.put("PROD001016881",new BigDecimal(499));
        specialProdMap.put("PROD001016628",new BigDecimal(599));
        specialProdMap.put("PROD001016627",new BigDecimal(599));
        specialProdMap.put("PROD001015528",new BigDecimal(1399));
        specialProdMap.put("PROD001015529",new BigDecimal(1999));

        specialSkuMap.put("411160162",new BigDecimal(499));
        specialSkuMap.put("411160172",new BigDecimal(599));
        specialSkuMap.put("S00300000013492",new BigDecimal(499));
        specialSkuMap.put("S00300000013493",new BigDecimal(599));
        specialSkuMap.put("S00300000013958",new BigDecimal(499));
        specialSkuMap.put("S00300000013959",new BigDecimal(599));
        specialSkuMap.put("S00300000013954",new BigDecimal(499));
        specialSkuMap.put("S00300000013955",new BigDecimal(599));
        specialSkuMap.put("411161992",new BigDecimal(599));
        specialSkuMap.put("411162002",new BigDecimal(699));
        specialSkuMap.put("411162012",new BigDecimal(599));
        specialSkuMap.put("411162022",new BigDecimal(699));
        specialSkuMap.put("412160542",new BigDecimal(1399));
        specialSkuMap.put("412160552",new BigDecimal(1499));
        specialSkuMap.put("412160582",new BigDecimal(1999));
        specialSkuMap.put("412160592",new BigDecimal(2199));

        special481ProdMap.put("PROD001013069",new BigDecimal(60));
        special481ProdMap.put("PROD001013065",new BigDecimal(60));
        special481ProdMap.put("PROD001013068",new BigDecimal(60));
        special481ProdMap.put("PROD001013067",new BigDecimal(60));

        special481SkuMap.put("17035071",new BigDecimal(169));
        special481SkuMap.put("17035073",new BigDecimal(169));
        special481SkuMap.put("17035076",new BigDecimal(169));
        special481SkuMap.put("16036075",new BigDecimal(169));

        special482ProdMap.put("PROD001013910",new BigDecimal(78));
        special482SkuMap.put("17035081",new BigDecimal(263));

        special463ProdMap.put("PROD001015182",new BigDecimal(299));
        special463ProdMap.put("PROD001015184",new BigDecimal(299));
        special463ProdMap.put("PROD001015185",new BigDecimal(299));

        special463SkuMap.put("411161282",new BigDecimal(799));
        special463SkuMap.put("411161292",new BigDecimal(899));
        special463SkuMap.put("411161302",new BigDecimal(799));
        special463SkuMap.put("411161312",new BigDecimal(899));
        special463SkuMap.put("411161322",new BigDecimal(799));
        special463SkuMap.put("411161332",new BigDecimal(899));

        special503ProdMap.put("PROD001016628",new BigDecimal(599));
        special503ProdMap.put("PROD001016627",new BigDecimal(599));

        special503SkuMap.put("411161992",new BigDecimal(599));
        special503SkuMap.put("411162002",new BigDecimal(699));
        special503SkuMap.put("411162012",new BigDecimal(599));
        special503SkuMap.put("411162022",new BigDecimal(699));

        special574ProdMap.put("PROD001013910",new BigDecimal(45));

        special574SkuMap.put("16035125",new BigDecimal(45));
        special574SkuMap.put("16035131",new BigDecimal(45));
        special574SkuMap.put("16035130",new BigDecimal(45));
        special574SkuMap.put("16035129",new BigDecimal(45));
        special574SkuMap.put("17035081",new BigDecimal(169));

        special590ProdMap.put("PROD001015182",new BigDecimal(299));
        special590ProdMap.put("PROD001015184",new BigDecimal(299));
        special590ProdMap.put("PROD001015185",new BigDecimal(299));

        special590SkuMap.put("411161282",new BigDecimal(799));
        special590SkuMap.put("411161292",new BigDecimal(899));
        special590SkuMap.put("411161302",new BigDecimal(799));
        special590SkuMap.put("411161312",new BigDecimal(899));
        special590SkuMap.put("411161322",new BigDecimal(799));
        special590SkuMap.put("411161332",new BigDecimal(899));

        special591ProdMap.put("PROD001015528",new BigDecimal(1399));

        special591SkuMap.put("412160542",new BigDecimal(1399));
        special591SkuMap.put("412160552",new BigDecimal(1499));

        special592ProdMap.put("PROD001015529",new BigDecimal(1999));

        special592SkuMap.put("412160582",new BigDecimal(1999));
        special592SkuMap.put("412160592",new BigDecimal(2199));

        special594ProdMap.put("PROD001016671",new BigDecimal(499));
        special594ProdMap.put("PROD001016672",new BigDecimal(499));
        special594ProdMap.put("PROD001016880",new BigDecimal(499));
        special594ProdMap.put("PROD001016881",new BigDecimal(499));

        special594SkuMap.put("411162070",new BigDecimal(499));
        special594SkuMap.put("411162080",new BigDecimal(599));
        special594SkuMap.put("411162110",new BigDecimal(499));
        special594SkuMap.put("411162120",new BigDecimal(599));
        special594SkuMap.put("S00300000013958",new BigDecimal(499));
        special594SkuMap.put("S00300000013959",new BigDecimal(599));
        special594SkuMap.put("S00300000013954",new BigDecimal(499));
        special594SkuMap.put("S00300000013955",new BigDecimal(599));

    }

    private static Map<String, Boolean> specialExcludeCampaignMap = new HashMap<>();
    static {
        PsCampaignVO specialCampaign = new PsCampaignVO();
        specialCampaign.setProductScopeId(3);
        specialCampaign.setDiscountTypeId(4);
        specialExcludeCampaignMap = getSpecialCampaignMap(Lists.newArrayList(specialCampaign));
    }

    private static Map<String, Boolean> getSpecialCampaignMap(List<PsCampaignVO> specialCampaigns) {
        Map<String, Boolean> map = new HashMap<>();
        for (PsCampaignVO specialCampaign : specialCampaigns) {
            String key = getSpecialCampaignKey(specialCampaign);
            map.put(key, true);
        }
        return map;
    }

    private static String getSpecialCampaignKey(PsCampaignVO specialCampaign) {
        String key = "sid=" + specialCampaign.getProductScopeId();
        key = key + ",tid=" + specialCampaign.getDiscountTypeId();
        return key;
    }



    public AbstractSpecialPriceCalculator(PriceCalculator sourcePriceCalculator) {
        super(sourcePriceCalculator);
    }
}
