package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCostPriceChangeMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuSalesPriceChangeMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuSupplierChangeMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuSalesPriceChangeDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.*;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuSalesPriceChangeVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSkuSalesPriceChangeDomain")
public class PcsSkuSalesPriceChangeDomainImpl implements PcsSkuSalesPriceChangeDomain, CheckAble {

    @Autowired
    private PcsSkuSalesPriceChangeMapper pcsSkuSalesPriceChangeMapper;
    @Autowired
    private PcsSkuCostPriceChangeMapper pcsSkuCostPriceChangeMapper;
    @Autowired
    private PcsSkuSupplierChangeMapper pcsSkuSupplierChangeMapper;

    @Override
    public PcsSkuSalesPriceChangeVO buildFromModel(PcsSkuSalesPriceChange record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuSalesPriceChangeVO vo = new PcsSkuSalesPriceChangeVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public PcsSkuSalesPriceChange bulidFromVO(PcsSkuSalesPriceChangeVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public Long create(String code, BigDecimal price) {
        PcsSkuSalesPriceChange record = new PcsSkuSalesPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (check(record)) {
            if (check(record, true)) {
                record.setChangeTime(new Date());
                record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
                pcsSkuSalesPriceChangeMapper.insertSelective(record);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuSalesPriceChange record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsSkuSalesPriceChangeMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsSkuSalesPriceChange findById(long id) {
        return pcsSkuSalesPriceChangeMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuSalesPriceChange> findByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSalesPriceChange> recordList = pcsSkuSalesPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public PcsSkuSalesPriceChange auditSkuSalesPriceChange(String code, Boolean isPass, Integer type) {
    	if(type.equals(1)){
    		type = PcsSkuSalesPriceChange.STATUS_PROCESSING;
    	}else{
    		type = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
    	}
        PcsSkuSalesPriceChange record = findSkuSalesPriceChangeByCodeAndProcessing(code, type);
        if(EmptyUtil.isNotEmpty(record)) {
        	Integer status = 1;
        	if(isPass){
        		if(type.equals(1)){//品类经理通过
        			status = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
        		}else{//财务通过
        			status = PcsSkuSalesPriceChange.STATUS_SUCCESS;
        		}
        	}else{
        		status = PcsSkuSalesPriceChange.STATUS_REJECT;
        	}
        	record.setChangeStatus(status);
            if (update(record)) {
                return record;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
            }
        }  else {
        	return null;
        }
    }

    @Override
    public PcsSkuSalesPriceChange findSkuSalesPriceChangeByCodeAndProcessing(String code, Integer type) {
        List<PcsSkuSalesPriceChange> list = findByCodeAndStatus(code, type);
        if (list.size() == 1) {
            return list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
        	list = findByCodeAndStatus(code, 4);
        	if(EmptyUtil.isNotEmpty(list)) {
        		return list.get(0);
        	} else {
        		return null;
        	}
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsSkuSalesPriceChange record = (PcsSkuSalesPriceChange) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsSkuSalesPriceChange record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuSalesPriceChange> oldList = findByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU售价审批还未通过或驳回");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU售价审批还未通过或驳回");
        }
        return true;
    }

    @Override
    public Long createSupplierChange(String code, Integer supplierId) {
        PcsSkuSupplierChange record = new PcsSkuSupplierChange();
        record.setSkuCode(code);
        record.setNewSupplierId(supplierId);;
        if (checkSupplierChange(record, true)) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            pcsSkuSupplierChangeMapper.insertSelective(record);
        }
        return null;
    }

    private Boolean checkCostPriceChange(PcsSkuCostPriceChange record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuCostPriceChange> oldList = findCostPriceChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU成本审批还未通过或驳回");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU成本审批还未通过或驳回");
        }
        return true;
    }

    private Boolean checkSupplierChange(PcsSkuSupplierChange record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        List<PcsSkuSupplierChange> oldList = findSupplierChangeByCodeAndStatus(record.getSkuCode(), PcsSkuSalesPriceChange.STATUS_PROCESSING);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU供应商审批还未通过或驳回");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "前一个SKU供应商审批还未通过或驳回");
        }
        return true;
    }
    @Override
    public Long createCostPriceChange(String code, BigDecimal price) {
        PcsSkuCostPriceChange record = new PcsSkuCostPriceChange();
        record.setSkuCode(code);
        record.setNewPrice(price);
        if (checkCostPriceChange(record, true)) {
            record.setChangeTime(new Date());
            record.setChangeStatus(PcsSkuSalesPriceChange.STATUS_PROCESSING);
            pcsSkuCostPriceChangeMapper.insertSelective(record);
        }
        return null;
    }

    @Override
    public PcsSkuCostPriceChange auditSkuCostPriceChange(String code, Boolean isPass, Integer type) {
    	PcsSkuCostPriceChange record = null;
		if(type.equals(1)){
    		type = PcsSkuSalesPriceChange.STATUS_PROCESSING;
    	}else{
    		type = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
    	}
		List<PcsSkuCostPriceChange> list = findCostPriceChangeByCodeAndStatus(code, type);
		if(list == null) {
			return null;
		} else if (list.size() == 1) {
        	record = list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
            return null;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
		Integer status = 1;
    	if(isPass){
    		if(type.equals(1)){//品类经理通过
    			status = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
    		}else{//财务通过
    			status = PcsSkuSalesPriceChange.STATUS_SUCCESS;
    		}
    	}else{
    		status = PcsSkuSalesPriceChange.STATUS_REJECT;
    	}
        record.setChangeStatus(status);
        if (checkCostPriceChange(record, false)) { 
        	if(pcsSkuCostPriceChangeMapper.updateByPrimaryKeySelective(record) != 0) {
        		  return record;
        	}
        	return record;
        	
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        }
    }

    @Override
    public PcsSkuSupplierChange auditSkuSupplierChange(String code, Boolean isPass, Integer type) {
    	PcsSkuSupplierChange record = null;
		if(type.equals(1)){
    		type = PcsSkuSalesPriceChange.STATUS_PROCESSING;
    	}else{
    		type = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
    	}
		List<PcsSkuSupplierChange> list = findSupplierChangeByCodeAndStatus(code, type);
        if (list.size() == 1) {
        	record = list.get(0);
        } else if (list.size() > 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.FINDBY_CODE_DUPLICATE, "当前SKUCODE有两条以上(含两条)处理中的售价变更,每次只能有一个处理中的售价变更");
        } else if (list.size() == 0) {
            return null;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        Integer status = 1;
    	if(isPass){
    		if(type.equals(1)){//品类经理通过
    			status = PcsSkuSalesPriceChange.CATEGORY_MANAGER_STATUS_SUCCESS;
    		}else{//财务通过
    			status = PcsSkuSalesPriceChange.STATUS_SUCCESS;
    		}
    	}else{
    		status = PcsSkuSalesPriceChange.STATUS_REJECT;
    	}
        record.setChangeStatus(status);
        if (checkSupplierChange(record, false)) { 
        	if(pcsSkuSupplierChangeMapper.updateByPrimaryKeySelective(record) != 0) {
        		  return record;
        	}
        	return record;
        	
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        }
    }

    @Override
    public List<PcsSkuCostPriceChange> findCostPriceChangeByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuCostPriceChange> recordList = pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public List<PcsSkuSupplierChange> findSupplierChangeByCodeAndStatus(String code, Integer status) {
        if (EmptyUtil.isEmpty(code) || EmptyUtil.isEmpty(status)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code).andChangeStatusEqualTo(status);
        List<PcsSkuSupplierChange> recordList = pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public List<PcsSkuSalesPriceChange> findByCode(String code) {
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuSalesPriceChangeExample example = new PcsSkuSalesPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuSalesPriceChange> recordList = pcsSkuSalesPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public List<PcsSkuCostPriceChange> findCostPriceChangeByCode(String code) {
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuCostPriceChangeExample example = new PcsSkuCostPriceChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuCostPriceChange> recordList = pcsSkuCostPriceChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public List<PcsSkuSupplierChange> findSupplierChangeByCode(String code) {
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuSupplierChangeExample example = new PcsSkuSupplierChangeExample();
        example.createCriteria().andSkuCodeEqualTo(code);
        List<PcsSkuSupplierChange> recordList = pcsSkuSupplierChangeMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }


	@Override
	public int updateCostPriceChange(PcsSkuCostPriceChange record) {
		return pcsSkuCostPriceChangeMapper.updateByPrimaryKeySelective(record);
	}

	@Override
	public int addCostPriceChange(PcsSkuCostPriceChange record) {
		return pcsSkuCostPriceChangeMapper.insertSelective(record);
	}

}
