package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuReceiveStandardCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuReceiveStandardRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuReceiveStandardDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandard;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuReceiveStandardRule;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardRuleVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuReceiveStandardVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSkuReceiveStandardDomain")
public class PcsSkuReceiveStandardDomainImpl implements PcsSkuReceiveStandardDomain {


    @Autowired
    private PcsSkuReceiveStandardMapper pcsSkuReceiveStandardMapper;

    @Autowired
    private PcsSkuReceiveStandardRuleMapper pcsSkuReceiveStandardRuleMapper;

    @Override
    public List<PcsSkuReceiveStandardVO> listSkuByCond(PcsSkuReceiveStandardCond cond) {
        return pcsSkuReceiveStandardMapper.listSkuByCond(cond);
    }

    @Override
    @Transactional
    public boolean createOrEditSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        if(EmptyUtil.isEmpty(vo.getId())){
            return createSkuReceiveStandard(vo);
        }else{
            return editSkuReceiveStandard(vo);
        }
    }

    @Override
    @Transactional
    public boolean saveReceiveStandardBySkuCode(List<PcsSkuReceiveStandardVO> voList) {
        boolean result = false;
        for(PcsSkuReceiveStandardVO standardVO : voList){
            result = saveReceiveStandardBySkuCode(standardVO);
            if(!result){
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "保存失败!");
            }
        }
        return result;
    }

    private  boolean saveReceiveStandardBySkuCode(PcsSkuReceiveStandardVO vo){
        boolean updateSuccess = updateReceiveStandardBySkuCode(vo);
        if(!updateSuccess){
            updateSuccess = saveReceiveStandard(vo);
        }
        if(updateSuccess){
            updateSkuReciveStandardRule(vo);
        }
        return updateSuccess;
    }


    private boolean updateReceiveStandardBySkuCode(PcsSkuReceiveStandardVO vo){
        int result = pcsSkuReceiveStandardMapper.updateReceiveStandardBySkuCode(vo);
        return result==1;
    }

    private boolean saveReceiveStandard(PcsSkuReceiveStandardVO vo){
        pcsSkuReceiveStandardMapper.saveReceiveStandard(vo);
        return true;
    }

    @Override
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(
            String skuCode) {
        return findPcsSkuReceiveStandardBySkuCode(skuCode,false);
    }

    @Override
    public PcsSkuReceiveStandardVO findPcsSkuReceiveStandardBySkuCode(String skuCode, boolean cascade) {
        PcsSkuReceiveStandardVO standardVO = pcsSkuReceiveStandardMapper.findPcsSkuReceiveStandardBySkuCode(skuCode);
        if(NullUtil.isNotNull(standardVO) && cascade){
            List<Long> ruleIds = pcsSkuReceiveStandardMapper.findReceiveRuleIdsBySkuCode(skuCode);
            standardVO.setReceiveRuleIds(ruleIds);
        }
        return standardVO;
    }

    @Override
    @Transactional
    public boolean editSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandard.class);
        return pcsSkuReceiveStandardMapper.updateByPrimaryKeySelective(record)==1?true:false;
    }

    @Override
    @Transactional
    public boolean createSkuReceiveStandard(PcsSkuReceiveStandardVO vo) {
        updateSkuReciveStandardRule(vo);
        PcsSkuReceiveStandard record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandard.class);
        return pcsSkuReceiveStandardMapper.insert(record)==1?true:false;
    }

    private void updateSkuReciveStandardRule(PcsSkuReceiveStandardVO vo){
        pcsSkuReceiveStandardMapper.deleteSkuReceiveStandardRuleBySkuCode(vo.getSkuCode());
        if(EmptyUtil.isNotEmpty(vo.getReceiveRuleIds())){
            for(Long ruleId : vo.getReceiveRuleIds()){
                pcsSkuReceiveStandardMapper.insertSkuReceiveStandardRule(vo.getSkuCode(),ruleId);
            }
        }
    }

    @Deprecated
    public List<PcsSkuReceiveStandardRuleVO> findAllReceiveStandardRule(){
        return pcsSkuReceiveStandardRuleMapper.findAllReceiveStandardRule();
    }

    @Deprecated
    public List<PcsSkuReceiveStandardRuleVO> findSkuReceiveStandardRule(String skuCode){
        return pcsSkuReceiveStandardRuleMapper.findSkuReceiveStandardRule(skuCode);
    }

    @Deprecated
    public PcsSkuReceiveStandardRuleVO findReceiveStandardRuleVOById(Long id){
        PcsSkuReceiveStandardRule rule = pcsSkuReceiveStandardRuleMapper.selectByPrimaryKey(id);
        PcsSkuReceiveStandardRuleVO ruleVO = new PcsSkuReceiveStandardRuleVO();
        BeanUtils.copyProperties(rule, ruleVO);
        return ruleVO;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean createReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_ON);
        PcsSkuReceiveStandardRule record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandardRule.class);
        return pcsSkuReceiveStandardRuleMapper.insert(record)==1?true:false;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean updateReceiveStandardRule(PcsSkuReceiveStandardRuleVO vo){
        PcsSkuReceiveStandardRule record = BeanUtil.buildFrom(vo, PcsSkuReceiveStandardRule.class);
        return pcsSkuReceiveStandardRuleMapper.updateByPrimaryKeySelective(record)==1?true:false;
    }

    @Override
    @Transactional
    @Deprecated
    public boolean deleteReceiveStandardRule(Long id){
        PcsSkuReceiveStandardRuleVO vo = new PcsSkuReceiveStandardRuleVO();
        vo.setId(id);
        vo.setStatus(PcsSkuReceiveStandardRuleVO.STATUS_OFF);
        return updateReceiveStandardRule(vo);
    }

}
