package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.integration.sms.SmsUtil;
import com.thebeastshop.pegasus.integration.sms.SmsVO;
import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.constants.PcsSkuQualifyConstants;
import com.thebeastshop.pegasus.merchandise.dao.PcsSkuQualifyMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuQualifyDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualify;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualifyExample;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Component("pcsSkuQualifyDomain")
public class PcsSkuQualifyDomainImpl implements PcsSkuQualifyDomain, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsSkuQualifyDomainImpl.class);

    @Autowired
    private PcsSkuQualifyMapper pcsSkuQualifyMapper;

    @Override
    public PcsSkuQualify buildFromVO(PcsSkuQualifyVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsSkuQualify record = new PcsSkuQualify();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsSkuQualifyVO buildFromModel(PcsSkuQualify record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsSkuQualifyVO vo = new PcsSkuQualifyVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsSkuQualify record) {
    	record.setCreateTime(new Date());
        pcsSkuQualifyMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsSkuQualify record) {
    	record.setModifyTime(new Date());
         return pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }


    /**
     * 审批通知
     */
    private void  sendNotice(String code, UserInfo userInfo) {
        final SmsUtil smsUtil = SmsUtil.getInstance();
        final SmsVO smsVO = new SmsVO();
        smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("finance.Approval.Mobile");
        // 收件人
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getMobile()};
            smsVO.setMobileList(Arrays.asList(categoryManager));
        } else {
            smsVO.setMobileList(Arrays.asList(toNotifyUsers));
        }

        smsVO.setContent("您好，您有新的供应商需要审批，供应商："+ code +"，请尽快审批，谢谢！");
        smsUtil.send(smsVO);

        // 邮件VO
        commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("finance.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        if(userInfo != null ) {
            String[]  categoryManager = {userInfo.getEmail()};
            emailVO.setToAddressList(Arrays.asList(categoryManager));
        } else {
            emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        }
        emailVO.setSubject("供应商审批");
        emailVO.setContent("您好，您有新的供应商需要审批，供应商："+ code +"，请尽快审批，谢谢！");
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public PcsSkuQualify findById(Long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsSkuQualifyMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond) {
        List<PcsSkuQualifyVO> recordList = pcsSkuQualifyMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuQualify> findByCriteria(PcsSkuQualifyCond cond) {
        PcsSkuQualifyExample example = new PcsSkuQualifyExample();
        //conditions

        List<PcsSkuQualify> recordList = pcsSkuQualifyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsSkuQualify> findByIds(List<Long> ids) {
        List<PcsSkuQualify> recordList = new ArrayList<PcsSkuQualify>();
        for (long id : ids) {
            PcsSkuQualify record = findById(id);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type) {
    	PcsSkuQualify record = pcsSkuQualifyMapper.selectByPrimaryKey(id);
        record.setLastModifier(userId);
        
        // 是否需要后补
        boolean isPostMeeting = record.getIsPostMeeting() == PcsSkuQualifyConstants.AUDIT_IS_POST_MEETING;
        
        boolean isSetAuditStatus = false;
        // 设置流程
        if (type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OWN_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getOwnImportedFlowTrend(isPass).get(record.getAuditStatus()));
        	if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_QA_FIRST_AUDIT_PASS);
        		isSetAuditStatus = true;
        	}else if(record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_PASS){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
        		isSetAuditStatus = true;
        	}
        }else if(type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OTHER_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getOtherImportedFlowTrend(isPass,isPostMeeting).get(record.getAuditStatus()));
        	if (isPostMeeting && isPass){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS_ISPOSTMEETING);
        		isSetAuditStatus = true;
        	}
        }else if(type == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_NOT_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getNotImportedFlowTrend(isPass).get(record.getAuditStatus()));
        }
        
        // 设置状态
        if (!isSetAuditStatus){
        	if (!isPass){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
        	}else if(record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
        	}else{
        		record.setAuditStatus(record.getFlowTrend());
        	}
        }
//        else { //驳回
//        	if (isOwnImported){
//        		// 自进口，若当前流程为QA终审，则驳回到 “待进口部上传文件”流程阶段
//        		if (record.getAuditStatus() == PcsSkuQualifyConstants.AUDIT_STATUS_QA_FINAL_AUDIT){
//        			record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_IMPORTDEP_SUBMIT_DOC);
//        		}else{
//        			// 其它阶段，则驳回到“提交审批文件”流程阶段
//        			record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_SUBMIT_DOC);
//        		}
//        	}else if(isOtherOwnImported){
//        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_SUBMIT_DOC);
//        	}else if(isNotImported){
//        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_SUBMIT_DOC);
//        	}
//        }
        return this.pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }
    
    @Override
    public Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass,Integer importedType) {
    	PcsSkuQualify record = pcsSkuQualifyMapper.selectByPrimaryKey(vo.getPendingId());
        record.setLastModifier(vo.getApproverId());
        record.setAuditDecision(vo.getAuditDecision());
        record.setAutonomousDetection(vo.getAutonomousDetection());
        record.setRiskLevel(vo.getRiskLevel());
        record.setRiskDesc(vo.getRiskDesc());
        record.setModifyTime(new Date());
        
        // 是否需要后补
        boolean isPostMeeting = record.getIsPostMeeting() == PcsSkuQualifyConstants.AUDIT_IS_POST_MEETING;
        
        boolean isSetAuditStatus = false;
        Integer flowTrend = record.getFlowTrend();
        // 设置流程
        if (importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OWN_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getOwnImportedFlowTrend(isPass).get(record.getFlowTrend()));
        	if (record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE){
        		// 终审驳回阶段
                if (flowTrend == PcsSkuQualifyConstants.FLOW_TREND_QA_FINAL_AUDIT){
        			if (isPass){
        				record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
        			}else{
        				record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
        			}
        		}else{
        			record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_QA_FIRST_AUDIT_PASS);
        		}
        		isSetAuditStatus = true;
        	}else if(record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_PASS){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
        		isSetAuditStatus = true;
        	}
        }else if(importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_OTHER_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getOtherImportedFlowTrend(isPass,isPostMeeting).get(record.getFlowTrend()));
        }else if(importedType == PcsSkuQualifyConstants.AUDIT_IMPORT__TYPE_NOT_IMPORTED){
        	record.setFlowTrend(PcsSkuQualifyConstants.getNotImportedFlowTrend(isPass).get(record.getFlowTrend()));
        }
        
        // 设置状态
        if (!isSetAuditStatus){
        	if (!isPass){
        		record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_REJECT);
        	}else if(record.getFlowTrend() == PcsSkuQualifyConstants.FLOW_TREND_AWAIT_CREATE_PURCHASE){
                if (isPostMeeting){
                    record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS_ISPOSTMEETING);
                }else{
                    record.setAuditStatus(PcsSkuQualifyConstants.AUDIT_STATUS_PASS);
                }
        	}else{
        		record.setAuditStatus(record.getFlowTrend());
        	}
        }
        return this.pcsSkuQualifyMapper.updateByPrimaryKeySelective(record) != 0;
    }
    
    @Override
	public Boolean auditSkuQualify(long id, Boolean isPass, Integer type) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
    public long countByCond(PcsSkuQualifyCond cond) {
        return pcsSkuQualifyMapper.countByCond(cond);
    }

	@Override
	public Boolean check(Object obj) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public PcsSkuQualify findBySkuCode(String skuCode) {
		PcsSkuQualifyVO vo = pcsSkuQualifyMapper.findBySkuCode(skuCode);
		return buildFromVO(vo);
	}

	@Override
	@Transactional
	public boolean createApprovalRecord(ApprovalRecordVO vo) {
		return pcsSkuQualifyMapper.createApprovalRecord(vo) == 1;
	}

	@Override
	public List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond) {
		return pcsSkuQualifyMapper.findApprovalRecordsByCond(cond);
	}

    @Override
    public long getFileCountByCond(PcsSkuQualifyCond cond) {
        return pcsSkuQualifyMapper.getFileCountByCond(cond);
    }
}
