package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsSkuImgMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuImgDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuImg;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuImgExample;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
@Component("pcsSkuImgDomain")
public class PcsSkuImgDomainImpl implements PcsSkuImgDomain {


    @Autowired
    private PcsSkuImgMapper pcsSkuImgMapper;

    @Override
    public boolean create(PcsSkuImg pcsSkuImg) {
        return pcsSkuImgMapper.insert(pcsSkuImg) != 0;
    }

    @Override
    public boolean update(PcsSkuImg pcsSkuImg) {
        return pcsSkuImgMapper.updateByPrimaryKeySelective(pcsSkuImg) != 0;
    }

    @Override
    public List<PcsSkuImg> findByCode(String code, Boolean isEnable) {
        PcsSkuImgExample example = new PcsSkuImgExample();
        PcsSkuImgExample.Criteria or1 = example.or();
        PcsSkuImgExample.Criteria or2 = example.or();
        or1.andSkuCodeEqualTo(code);
        or2.andProductCodeEqualTo(code);
        if (null != isEnable) {
            or1.andCancelFlagEqualTo(isEnable ? PcsSkuImg.CANCEL_NO : PcsSkuImg.CANCEL_YES);
            or2.andCancelFlagEqualTo(isEnable ? PcsSkuImg.CANCEL_NO : PcsSkuImg.CANCEL_YES);
        }
        example.setOrderByClause("seq");//根号seq进行排序

        return pcsSkuImgMapper.selectByExample(example);
    }

    @Override
    /*新增*/
    public boolean create(List<PcsSkuImg> pcsSkuImgs) {
        if (CollectionUtils.isEmpty(pcsSkuImgs)) return false;

        String code = pcsSkuImgs.get(0).getProductCode();
        if (StringUtils.isBlank(code)) {
            code = pcsSkuImgs.get(0).getSkuCode();
        }

        List<PcsSkuImg> cancelImgs = findByCode(code, true);


        boolean succ = false;
        for (PcsSkuImg pcsSkuImg : pcsSkuImgs) {
            succ |= create(pcsSkuImg);
        }
        if (succ) {
            for (PcsSkuImg pcsSkuImg : pcsSkuImgs) {//添加
                for(PcsSkuImg cancelImg :cancelImgs){//库
                    if(pcsSkuImg.getSeq().equals(cancelImg.getSeq())){
                        cancelImg.setCancelFlag(PcsSkuImg.CANCEL_YES);
                        update(cancelImg);
                    }
                }
//                create(pcsSkuImg);
            }
            /*for (PcsSkuImg cancelImg : cancelImgs) {
                if (PcsSkuImg.CANCEL_NO.equals(cancelImg.getCancelFlag()))
                    cancelImg.setCancelFlag(PcsSkuImg.CANCEL_YES);
                update(cancelImg);
            }*/
        }
        return succ;
    }

}
