package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsSkuCmSplMapper;
import com.thebeastshop.pegasus.merchandise.domain.BaseDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSplExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

/**
 * @author Eric.Lou
 * @update gongjun 2016-08-30
 * @version $Id: PcsSkuCustomMadeSupplerImpl.java, v 0.1 2015-08-06 13:07
 */
@Component("pcsSkuCmSplDomain")
public class PcsSkuCmSplDomainImpl extends AbstractBaseDomain<PcsSkuCmSplVO, PcsSkuCmSpl> implements PcsSkuCmSplDomain, CheckAble {

    @Autowired
    private PcsSkuCmSplMapper pcsSkuCmSplMapper;

    @Override
    @Transactional
    public Long create(PcsSkuCmSpl record) {
        if (check(record)) {
            if (check(record, true)) {
                record.setIsSelected(PegasusConstants.NO);
                pcsSkuCmSplMapper.insertSelective(record);
                return record.getId();
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsSkuCmSpl record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsSkuCmSplMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsSkuCmSpl findById(long id) {
        return pcsSkuCmSplMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsSkuCmSplVO> findBySkuCustomMadeId(long skuCustomMadeId) {
        List<PcsSkuCmSplVO> recordList = pcsSkuCmSplMapper.findPcsSkuCmSplBySkuCustomMadeId(skuCustomMadeId);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    @Transactional
    public boolean deleteById(long id) {
        PcsSkuCmSpl record = findById(id);
        if (EmptyUtil.isNotEmpty(record)) {
            return pcsSkuCmSplMapper.deleteByPrimaryKey(id) != 0;
        }
        return false;
    }

    @Override
    public Boolean check(Object obj) {
        PcsSkuCmSpl record = (PcsSkuCmSpl) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (EmptyUtil.isEmpty(record.getSupplierId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "供应商编号不能为空");
        }
        if (EmptyUtil.isEmpty(record.getSkuCustomMadeId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "SKU定制单号不能为空");
        }
        return true;
    }

    private Boolean check(PcsSkuCmSpl record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PcsSkuCmSplExample example = new PcsSkuCmSplExample();
        example.createCriteria().andSupplierIdEqualTo(record.getSupplierId()).andSkuCustomMadeIdEqualTo(record.getSkuCustomMadeId());
        List<PcsSkuCmSpl> oldList = pcsSkuCmSplMapper.selectByExample(example);
        if (oldList.size() > 0 && isCreate) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "supplierId和skuCustomMadeId字段数据库已有相同的值不能重复");
        }
        if (oldList.size() > 0 && !isCreate && !oldList.get(0).getId().equals(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "supplierId和skuCustomMadeId字段数据库已有相同的值不能重复");
        }
        return true;
    }

}
