package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsReceiveRuleCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsReceiveRuleMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsMaterialCategoryDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsReceiveRuleDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsReceiveRule;
import com.thebeastshop.pegasus.merchandise.vo.PcsMaterialCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveMaterialQcItemVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsReceiveRuleVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/2/14.
 */
@Component("pcsReceiveRuleDomain")
public class PcsReceiveRuleDomainImpl extends AbstractBaseDomain<PcsReceiveRuleVO,PcsReceiveRule> implements PcsReceiveRuleDomain {

    @Autowired
    private PcsReceiveRuleMapper pcsReceiveRuleMapper;

    @Autowired
    private PcsMaterialCategoryDomain pcsMaterialCategoryDomain;

    @Override
    public PcsReceiveRuleVO findById(Long id,boolean cascade) {
        PcsReceiveRuleVO ruleVO = pcsReceiveRuleMapper.findById(id);
        if(cascade && NullUtil.isNotNull(ruleVO)){
            List<Long> materialCategoryIds = pcsReceiveRuleMapper.findMaterialCategoryIdByReceiveRuleId(ruleVO.getId());
            ruleVO.setMaterialCategoryIds(materialCategoryIds);
        }
        return ruleVO;
    }

    @Override
    public List<PcsReceiveRuleVO> findByCond(PcsReceiveRuleCond cond) {
        List<PcsReceiveRuleVO> ruleVOList = pcsReceiveRuleMapper.findByCond(cond);
        if(EmptyUtil.isNotEmpty(ruleVOList)){
            List<Long> ruleIds = new ArrayList<>();
            for(PcsReceiveRuleVO ruleVO : ruleVOList){
                ruleIds.add(ruleVO.getId());
            }
            List<PcsReceiveMaterialQcItemVO> list = pcsReceiveRuleMapper.findMaterialCategoryIdByReceiveRuleIds(ruleIds);
            if(EmptyUtil.isNotEmpty(list)){
                Map<Long,List<Long>> ruleMcMap = new HashMap<>();
                for(PcsReceiveMaterialQcItemVO mc : list){
                    List<Long> mcList = ruleMcMap.get(mc.getReceiveRuleId());
                    if(NullUtil.isNull(mcList)){
                        mcList = new ArrayList<>();
                        ruleMcMap.put(mc.getReceiveRuleId(),mcList);
                    }
                    mcList.add(mc.getMaterialCategoryId());
                }
                for(PcsReceiveRuleVO ruleVO : ruleVOList){
                    ruleVO.setMaterialCategoryIds(ruleMcMap.get(ruleVO.getId()));
                }
            }
        }
        return ruleVOList;
    }

    @Override
    @Transactional
    public boolean add(PcsReceiveRuleVO vo) {
        List<Long> materialCategoryIds = findLeafMaterialCategory(vo.getMaterialCategoryIds());
        vo.setMaterialCategoryIds(materialCategoryIds);
        PcsReceiveRule rule = buildFromVO(vo);
        pcsReceiveRuleMapper.insert(rule);
        pcsReceiveRuleMapper.updateCode(generateCode(rule.getId()),rule.getId());
        vo.setId(rule.getId());
        addReceiveMaterial(vo);
        return true;
    }

    @Override
    @Transactional
    public boolean add(List<PcsReceiveRuleVO> voList) {
        boolean result = false;
        if(EmptyUtil.isNotEmpty(voList)){
            for(PcsReceiveRuleVO vo : voList){
                result = add(vo);
                if(!result){
                    break;
                }
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean update(PcsReceiveRuleVO vo) {
        List<Long> materialCategoryIds = findLeafMaterialCategory(vo.getMaterialCategoryIds());
        vo.setMaterialCategoryIds(materialCategoryIds);
        pcsReceiveRuleMapper.updateByPrimaryKeySelective(buildFromVO(vo));
        delReceiveMaterialByReceiveRuleId(vo.getId());
        addReceiveMaterial(vo);
        return true;
    }

    @Override
    @Transactional
    public boolean update(List<PcsReceiveRuleVO> voList) {
        boolean result = false;
        if(EmptyUtil.isNotEmpty(voList)){
            for(PcsReceiveRuleVO vo : voList){
                result = update(vo);
                if(!result){
                    break;
                }
            }
        }
        return result;
    }

    @Override
    @Transactional
    public boolean del(Long id) {
        delReceiveMaterialByReceiveRuleId(id);
        pcsReceiveRuleMapper.deleteByPrimaryKey(id);
        return true;
    }

    private void delReceiveMaterialByReceiveRuleId(Long receiveRuleId){
        pcsReceiveRuleMapper.deleteQcItemByReceiveRuleId(receiveRuleId);
        pcsReceiveRuleMapper.deleteMaterialCategoryByReceiveRuleId(receiveRuleId);
    }

    private void addReceiveMaterial(PcsReceiveRuleVO vo){
        if(EmptyUtil.isNotEmpty(vo.getMaterialCategoryIds())){
            try{

                for(Long materialCategoryId : vo.getMaterialCategoryIds()){
                    pcsReceiveRuleMapper.insertMaterialCategoryQcItemId(materialCategoryId,vo.getQualityCheckItemId());
                    pcsReceiveRuleMapper.insertMaterialCategoryReceiveRuleId(materialCategoryId,vo.getId());
                }
            }catch (Exception e){
                //DuplicateKeyException 无法拦截
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "存在材质已经关联了划痕质检项下的某个规则！");
            }
        }
    }

    private List<Long> findLeafMaterialCategory(List<Long> materialCategoryIds){
        if(EmptyUtil.isEmpty(materialCategoryIds)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "无关联材质!");
        }
        List<PcsMaterialCategoryVO> leafCategorys = pcsMaterialCategoryDomain.findLeafById(materialCategoryIds);
        if(EmptyUtil.isEmpty(leafCategorys)){
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "无关联叶子材质分类!");
        }
        List<Long> leafCategoryIds = new ArrayList<>();
        for(PcsMaterialCategoryVO leaf : leafCategorys){
            leafCategoryIds.add(leaf.getId());
        }
        return leafCategoryIds;
    }

    private String generateCode(Long id){
        String code = id.toString();
        if(code.length()>=3){
            return code;
        }
        StringBuilder sb = new StringBuilder();
        for(int i=code.length();i<3;i++){
            sb.append("0");
        }
        return sb.toString()+code;
    }

}
