package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsQualificationMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsQualificationDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsQualification;
import com.thebeastshop.pegasus.merchandise.model.PcsQualificationExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Component("pcsQualificationDomain")
public class PcsQualificationDomainImpl implements PcsQualificationDomain, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsQualificationDomainImpl.class);

    @Autowired
    private PcsQualificationMapper pcsQualificationMapper;

    @Override
    public PcsQualification buildFromVO(PcsQualificationVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsQualification record = new PcsQualification();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsQualificationVO buildFromModel(PcsQualification record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsQualificationVO vo = new PcsQualificationVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsQualification record) {
          pcsQualificationMapper.insertSelective(record);
          return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsQualification record) {
         return pcsQualificationMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public PcsQualification findById(Long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsQualificationMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsQualificationVO> findByCond(PcsQualificationCond cond) {
        List<PcsQualificationVO> recordList = pcsQualificationMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsQualification> findByCriteria(PcsQualificationCond cond) {
    	PcsQualificationExample example = new PcsQualificationExample();
        //conditions
        if (cond.getQualifyId() != null){
            example.createCriteria().andQualifyIdEqualTo(cond.getQualifyId());
        }
    	if (StringUtils.isNotEmpty(cond.getCode())){
    		example.createCriteria().andCodeLike(SQLUtils.allLike(cond.getCode()));
    	}
    	if (cond.getType() != null){
    		example.createCriteria().andTypeEqualTo(cond.getType());
    	}
    	if (cond.getStartExpireDate() != null){
    		example.createCriteria().andExpireDateGreaterThanOrEqualTo(cond.getStartExpireDate());
    	}
    	if (cond.getEndExpireDate() != null){
    		example.createCriteria().andExpireDateLessThanOrEqualTo(cond.getEndExpireDate());
    	}
    	if (cond.getIsPostMeeting() != null){
    		example.createCriteria().andIsPostMeetingEqualTo(cond.getIsPostMeeting());
    	}
        List<PcsQualification> recordList = pcsQualificationMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsQualification> findByIds(List<Long> ids) {
        List<PcsQualification> recordList = new ArrayList<PcsQualification>();
        for (long id : ids) {
            PcsQualification record = findById(id);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public long countByCond(PcsQualificationCond cond) {
        return pcsQualificationMapper.countByCond(cond);
    }

	@Override
	public int deleteByPrimaryKey(Long id) {
		return pcsQualificationMapper.deleteByPrimaryKey(id);
	}

	@Override
	public Long deleteByQualifyId(Long qualifyId) {
		return pcsQualificationMapper.deleteByQualifyId(qualifyId);
	}

	@Override
	public List<PcsQualification> findByQualifyId(Long qualifyId) {
		List<PcsQualificationVO> list = pcsQualificationMapper.findByQualifyId(qualifyId);
		List<PcsQualification> docs = new ArrayList<PcsQualification>();
		for (PcsQualificationVO vo : list){
			docs.add(buildFromVO(vo));
		}
		return docs;
	}

	@Override
	public Boolean check(Object obj) {
		// TODO Auto-generated method stub
		return null;
	}

}
