package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.dao.PcsImportDocMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsImportDocDomain;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDoc;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDocExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Component("pcsImportDocDomain")
public class PcsImportDocDomainImpl implements PcsImportDocDomain, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsImportDocDomainImpl.class);

    @Autowired
    private PcsImportDocMapper pcsImportDocMapper;

    @Override
    public PcsImportDoc buildFromVO(PcsImportDocVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsImportDoc record = new PcsImportDoc();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsImportDocVO buildFromModel(PcsImportDoc record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsImportDocVO vo = new PcsImportDocVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsImportDoc record) {
          pcsImportDocMapper.insertSelective(record);
          return record.getId();
    }

    @Override
    @Transactional
    public Boolean update(PcsImportDoc record) {
         return pcsImportDocMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public PcsImportDoc findById(Long id) {
        if (EmptyUtil.isEmpty(id)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return pcsImportDocMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsImportDocVO> findByCond(PcsImportDocCond cond) {
        List<PcsImportDocVO> recordList = pcsImportDocMapper.findByCond(cond);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsImportDoc> findByCriteria(PcsImportDocCond cond) {
    	PcsImportDocExample example = new PcsImportDocExample();
        //conditions
    	if (cond.getDocType() != null){
    		example.createCriteria().andDocTypeEqualTo(cond.getDocType());
    	}
    	if (cond.getIsPostMeeting() != null){
    		example.createCriteria().andIsPostMeetingEqualTo(cond.getIsPostMeeting());
    	}
        List<PcsImportDoc> recordList = pcsImportDocMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        }
        return recordList;
    }

    @Override
    public List<PcsImportDoc> findByIds(List<Long> ids) {
        List<PcsImportDoc> recordList = new ArrayList<PcsImportDoc>();
        for (long id : ids) {
            PcsImportDoc record = findById(id);
            if (EmptyUtil.isNotEmpty(record) && EmptyUtil.isNotEmpty(record.getId())) {
                recordList.add(record);
            }
        }
        if (CollectionUtils.isEmpty(recordList)) {
            return Collections.emptyList();
        } else {
            return recordList;
        }
    }

    @Override
    public long countByCond(PcsImportDocCond cond) {
        return pcsImportDocMapper.countByCond(cond);
    }

	@Override
	public int deleteByPrimaryKey(Long id) {
		return pcsImportDocMapper.deleteByPrimaryKey(id);
	}

	@Override
	public Long deleteByQualifyId(Long qualifyId) {
		return pcsImportDocMapper.deleteByQualifyId(qualifyId);
	}

	@Override
	public List<PcsImportDoc> findByQualifyId(Long qualifyId) {
		List<PcsImportDocVO> list = pcsImportDocMapper.findByQualifyId(qualifyId);
		List<PcsImportDoc> docs = new ArrayList<PcsImportDoc>();
		for (PcsImportDocVO vo : list){
			docs.add(buildFromVO(vo));
		}
		return docs;
	}

	@Override
	public Boolean check(Object obj) {
		// TODO Auto-generated method stub
		return null;
	}

}
