package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.PcsCustomizeImageMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsCustomizeImageDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsCustomizeImage;
import com.thebeastshop.pegasus.merchandise.vo.PcsCustomizeImageVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author lk
 * @since 2016-12-08
 */
@Component("pcsCustomizeImageDomain")
public class PcsCustomizeImageDomainImpl extends AbstractBaseDomain<PcsCustomizeImageVO, PcsCustomizeImage> implements PcsCustomizeImageDomain {


    private final Logger log = LoggerFactory.getLogger(PcsCustomizeImageDomainImpl.class);

    @Autowired
    private PcsCustomizeImageMapper pcsCustomizeImageMapper;

    @Override
    @Transactional
    public Long create(PcsCustomizeImage record) {
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setActive(true);
        pcsCustomizeImageMapper.insertSelective(record);
        return record.getId();
    }

    @Override
    @Transactional
    public boolean update(PcsCustomizeImage record) {
        record.setUpdateTime(new Date());
        return pcsCustomizeImageMapper.updateByPrimaryKeySelective(record) != 0;
    }

    @Override
    public List<PcsCustomizeImageVO> findByCode(String code) {
        return pcsCustomizeImageMapper.findByCode(code);
    }
}
