package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdCopywriterCustomerMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdCopywriterMapper;
import com.thebeastshop.pegasus.merchandise.dao.PcsCopywriterMapper;
import com.thebeastshop.pegasus.merchandise.domain.PcsClPsDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsCopywriterDomain;
import com.thebeastshop.pegasus.merchandise.enums.CopywriterValidStatusEnum;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriter;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriterExample;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriter;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriterExample;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.management.OperationsException;
import java.util.*;

/**
 * Created by QTJ on 2017/6/12.
 */
@Component("pcsCopywriterDomain")
public class PcsCopywriterDomainImpl implements PcsCopywriterDomain {
    private final Logger log = LoggerFactory.getLogger(PcsCopywriterDomainImpl.class);

    @Autowired
    private PcsCopywriterMapper pcsCopywriterMapper;

    @Autowired
    private OpProdCopywriterMapper opProdCopywriterMapper;

    @Autowired
    private OpProdCopywriterCustomerMapper opProdCopywriterCustomerMapper;

    @Autowired
    private PcsClPsDomain pcsClPsDomain;

    @Override
    public int addCopywriter(PcsCopywriter pcsCopywriter) {
        pcsCopywriter.setActive(1);
        pcsCopywriter.setCreateTime(DateUtil.getNow());

        pcsCopywriter = copywriterValidStatus(pcsCopywriter);
        int ret = pcsCopywriterMapper.insertSelective(pcsCopywriter);
        if (ret>0){
            Random random = new Random();
            int n = random.nextInt(99);
            pcsCopywriter.setCode("C0"+n+pcsCopywriter.getId());
            pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
        }

        return ret;
    }

    /**
     * 判断水印状态
     * @param pcsCopywriter
     * @return
     */
    private PcsCopywriter copywriterValidStatus(PcsCopywriter pcsCopywriter){
        Date now = DateUtil.getNow();
        if (pcsCopywriter.getValidStartTime().after(now)){
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());
        }else if (pcsCopywriter.getValidStartTime().before(now) && pcsCopywriter.getValidEndTime().after(now)){
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());
        }else if (pcsCopywriter.getValidEndTime().before(now)){
            pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.Expired.getStatus());
        }
        return pcsCopywriter;
    }

    @Override
    public int updateCopywriter(PcsCopywriterVO copywriterVO) {
        PcsCopywriter pcsCopywriter = BeanUtil.buildFrom(copywriterVO,PcsCopywriter.class);
        pcsCopywriter = copywriterValidStatus(pcsCopywriter);
        int ret = pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
        if (ret > 0){
            //TODO 同步ES
            updateCopywriterValidStatus();
            //更新子表修改时间,触发ES同步
            int updateTime = opProdCopywriterCustomerMapper.updateProductCopywriterUpdateTimeByCopyId(pcsCopywriter.getId());
        }
        return ret;
    }

    @Override
    public int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate) {
        Map<String, Object> params = new HashMap<>();
        // 客户关系管理--PROD维护时，需要先清空
        if (isEmptyBeforeUpdate){
            // 删除无用的关联 每次更新时，先解除原先的关联关系
//            params.put("productId", prod.getProdId());
//            List<ProdWatermark> toDeleteProdWatermarkList = pcsWatermarkMapper.queryToDeleteProductWatermarkList(params);
            OpProdCopywriterExample example = new OpProdCopywriterExample();
            OpProdCopywriterExample.Criteria criteria = example.createCriteria();
            criteria.andProductIdEqualTo(prod.getProdId());
            criteria.andIsDeleteEqualTo(0);
            List<OpProdCopywriter> toDeleteProdCopywriterList = opProdCopywriterMapper.selectByExample(example);
            if (!toDeleteProdCopywriterList.isEmpty()) {
                List<Long> toDelIdList = new ArrayList<>();
                for (int i = 0; i < toDeleteProdCopywriterList.size(); i++) {
                    OpProdCopywriter toDelProdCopywriter = toDeleteProdCopywriterList.get(i);
                    toDelIdList.add(toDelProdCopywriter.getId());
                }
                Map<String, Object> delParams = new HashMap<>();
                delParams.put("ids", toDelIdList);
                delParams.put("active", 0);
                delParams.put("isDelete", 1);
                // 逻辑删除
                int count = opProdCopywriterCustomerMapper.updateProdCopywriterDeleteByIds(delParams);
                log.info("删除："+count);
            }
        }

        List<OpProdCopywriter> opProdCopywriterList = new ArrayList<>();

        for (int i = 0; i < copywriterCodeList.size(); i++) {
            String code = copywriterCodeList.get(i);

            OpProdCopywriter opProdCopywriter = new OpProdCopywriter();
            opProdCopywriter.setProductCode(prod.getProdCode());
            opProdCopywriter.setProductId(prod.getProdId());
            opProdCopywriter.setCopywriterCode(code);

            PcsCopywriterExample example = new PcsCopywriterExample();
            PcsCopywriterExample.Criteria criteria = example.createCriteria();
            criteria.andCodeEqualTo(code);
            List<PcsCopywriter> pcsCopywriter = pcsCopywriterMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(pcsCopywriter)){
                int validStatus = pcsCopywriter.get(0).getValidStatus();
                if (validStatus==CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus()){
                    opProdCopywriter.setActive(1);
                }else{
                    opProdCopywriter.setActive(0);
                }
            }
            opProdCopywriterList.add(opProdCopywriter);
        }

        // 添加或更新  产品文案关联表
        int ret = 0;
        for (int i = 0; i < opProdCopywriterList.size(); i++) {
            OpProdCopywriter opProdCopywriter = opProdCopywriterList.get(i);
            opProdCopywriter.setSort(i);
            try {
                ret = saveOrUpdateProdCopywriter(opProdCopywriter);
            } catch (OperationsException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public int saveOrUpdateProdCopywriter(OpProdCopywriter opProdCopywriter) throws OperationsException {
        int count = opProdCopywriterCustomerMapper.countOfProdCopywriter(opProdCopywriter);
        opProdCopywriter.setIsDelete(0);
        if (count == 0) {
            opProdCopywriter.setCreateTime(DateUtil.getNow());
            opProdCopywriter.setUpdateTime(DateUtil.getNow());
            count = opProdCopywriterMapper.insertSelective(opProdCopywriter);
            log.info("add record ProdCopywriterId:"+opProdCopywriter.getId());
            if (count == 0){
                throw new OperationsException("新增失败!");
            }
            return 1;// 新增
        }
        // prodWatermark.setId(pw.getId());

        opProdCopywriter.setUpdateTime(DateUtil.getNow());
        count = opProdCopywriterCustomerMapper.updateProdCopywriter(opProdCopywriter);
        if (count == 0){
            throw new OperationsException("更新失败!");
        }
        log.info("update record opProdCopywriterId:"+opProdCopywriter.getId());
        return 2;// 更新
    }

    @Override
    public PcsCopywriterVO findCopywriterById(Long id) {
        PcsCopywriterExample example = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        criteria.andActiveEqualTo(1);
        List<PcsCopywriter> pcsCopywriters = pcsCopywriterMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pcsCopywriters)){
            return BeanUtil.buildFrom(pcsCopywriters.get(0),PcsCopywriterVO.class);
        }
        return null;
    }

    @Override
    public List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond) {
        return opProdCopywriterCustomerMapper.queryProdCopywriterList(cond);
    }

    @Override
    public int deleteProdCopywriterByIds(List<String> idList) {
        Map<String, Object> params = new HashMap<>();
        params.put("ids", idList);
        params.put("isDelete", 1);
        params.put("active", 0);
        // 逻辑删除
        int ret = opProdCopywriterCustomerMapper.updateProdCopywriterDeleteByIds(params);
        return ret;
    }

    @Override
    public List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond) {
        log.info("queryPcsCopywriterVOListByCond查询参数:{}"+cond.toString());
        List<PcsCopywriterVO> pcsCopywriterVOList = opProdCopywriterCustomerMapper.queryPcsCopywriterVOListByCond(cond);

        return pcsCopywriterVOList;
    }

    @Override
    public ProdSkuVO queryProductByProdCode(String prodCode) {
        return opProdCopywriterCustomerMapper.queryProductByProdCode(prodCode);
    }

    @Override
    public void updateCopywriterValidStatus() {
        updatePENDING_EFFECT();
        updateALREADY_IN_FORCE();
        updateExpired();

    }

    @Override
    public Map<String, ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes) {
        log.info("-----通过ProdCodes查询 可以使用的文案----productCodes{}"+codes);
        updateCopywriterValidStatus();

        List<ProductCopywriterVO> productCopywriterVOList = opProdCopywriterCustomerMapper.selectProductCopywriterByProdCodes(codes);
        Map<String,ProductCopywriterVO> returnMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(productCopywriterVOList)){
            for (ProductCopywriterVO productCopywriterVO:productCopywriterVOList){
                returnMap.put(productCopywriterVO.getProductCode(),productCopywriterVO);
            }
        }
        return returnMap;
    }

    @Override
    public int updateActiveTrueCopywriter() {
        return opProdCopywriterCustomerMapper.updateActiveTrueCopywriter();
    }

    @Override
    public int updateActiveFalseCopywriter() {
        return opProdCopywriterCustomerMapper.updateActiveFalseCopywriter();
    }

    @Override
    public int updateValidStatusPendingEffect() {
        return opProdCopywriterCustomerMapper.updateValidStatusPendingEffect();
    }

    @Override
    public int updateValidStatusAlreadyInForce() {
        return opProdCopywriterCustomerMapper.updateValidStatusAlreadyInForce();
    }

    @Override
    public int updateValidStatusExpired() {
        return opProdCopywriterCustomerMapper.updateValidStatusExpired();
    }

    private void updatePENDING_EFFECT(){
        //更新为待生效
        PcsCopywriterExample example = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria = example.createCriteria();
        criteria.andValidStartTimeGreaterThan(DateUtil.getNow());//开始时间大于now
        criteria.andActiveNotEqualTo(0);// 不是删除的
        criteria.andValidStatusNotEqualTo(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());

        PcsCopywriterExample.Criteria criteriaOr = example.createCriteria();
        criteriaOr.andValidStartTimeGreaterThan(DateUtil.getNow());//开始时间大于now
        criteriaOr.andActiveNotEqualTo(0);// 不是删除的
        criteriaOr.andValidStatusIsNull();
        example.or(criteriaOr);


        List<PcsCopywriter> pcsCopywriters = pcsCopywriterMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pcsCopywriters)){
            for (PcsCopywriter pcsCopywriter:pcsCopywriters){
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.PENDING_EFFECT.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret<1){
                    log.error("文案{}更新为待生效失败"+pcsCopywriter.getId());
                }
            }
        }
    }

    private void updateALREADY_IN_FORCE(){
        //更新为已生效
        PcsCopywriterExample example1 = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria1 = example1.createCriteria();
        criteria1.andValidStartTimeLessThan(DateUtil.getNow());//开始时间小于now
        criteria1.andValidEndTimeGreaterThan(DateUtil.getNow());//结束时间大于now
        criteria1.andActiveNotEqualTo(0);// 不是删除的
        criteria1.andValidStatusNotEqualTo(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());//不等于已生效

        PcsCopywriterExample.Criteria criteria11 = example1.createCriteria();
        criteria11.andValidStartTimeLessThan(DateUtil.getNow());//开始时间小于now
        criteria11.andValidEndTimeGreaterThan(DateUtil.getNow());//结束时间大于now
        criteria11.andActiveNotEqualTo(0);// 不是删除的
        criteria11.andValidStatusIsNull();
        example1.or(criteria11);

        List<PcsCopywriter> pcsCopywriters1 = pcsCopywriterMapper.selectByExample(example1);
        if (CollectionUtils.isNotEmpty(pcsCopywriters1)){
            for (PcsCopywriter pcsCopywriter:pcsCopywriters1){
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.ALREADY_IN_FORCE.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret<1){
                    log.error("文案{}更新为已生效失败"+pcsCopywriter.getId());
                }
            }
        }
    }

    private void updateExpired(){
        //更新为 失效
        PcsCopywriterExample example2 = new PcsCopywriterExample();
        PcsCopywriterExample.Criteria criteria2 = example2.createCriteria();
        criteria2.andValidEndTimeLessThan(DateUtil.getNow());//结束时间小于now
        criteria2.andActiveNotEqualTo(0);// 不是删除的
        criteria2.andValidStatusNotEqualTo(CopywriterValidStatusEnum.Expired.getStatus());//不等于已失效

        PcsCopywriterExample.Criteria criteria22 = example2.createCriteria();
        criteria22.andValidEndTimeLessThan(DateUtil.getNow());//结束时间小于now
        criteria22.andActiveNotEqualTo(0);// 不是删除的
        criteria22.andValidStatusIsNull();
        example2.or(criteria22);



        List<PcsCopywriter> pcsCopywriters2 = pcsCopywriterMapper.selectByExample(example2);
        if (CollectionUtils.isNotEmpty(pcsCopywriters2)){
            for (PcsCopywriter pcsCopywriter:pcsCopywriters2){
                pcsCopywriter.setValidStatus(CopywriterValidStatusEnum.Expired.getStatus());
                pcsCopywriter.setUpdateTime(DateUtil.getNow());
                int ret = pcsCopywriterMapper.updateByPrimaryKeySelective(pcsCopywriter);
                if (ret<1){
                    log.error("文案{}更新为已失效失败"+pcsCopywriter.getId());
                }
            }
        }
    }


}
