/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.dao.OpProdCanSelfDeliveryMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdCanSelfDeliveryDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProdCanSelfDelivery;
import com.thebeastshop.pegasus.merchandise.model.OpProdCanSelfDeliveryExample;
import com.thebeastshop.pegasus.merchandise.vo.OpProdCanSelfDeliveryVO;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:27
 */
@Component("opProdCanSelfDeliveryDomain")
public class OpProdCanSelfDeliveryDomainImpl extends AbstractBaseDomain<OpProdCanSelfDeliveryVO, OpProdCanSelfDelivery>
        implements OpProdCanSelfDeliveryDomain {

    private static final Logger log = LoggerFactory.getLogger(OpProdCanSelfDeliveryDomainImpl.class);

    @Autowired
    private OpProdCanSelfDeliveryMapper opProdCanDeliveryMapper;

    @Override
    public boolean create(OpProdCanSelfDelivery delivery) {
        if (CollectionUtils.isNotEmpty(findByProdIdDistId(delivery.getProductId(), delivery.getDistrictId()))) {
            return false;
        }
        return opProdCanDeliveryMapper.insert(delivery) != 0;
    }

    @Override
    public boolean update(OpProdCanSelfDelivery delivery) {
        return opProdCanDeliveryMapper.updateByPrimaryKeySelective(delivery) != 0;
    }

    @Override
    public boolean deleteById(Long id) {
        return opProdCanDeliveryMapper.deleteByPrimaryKey(id) != 0;
    }

    @Override
    public List<OpProdCanSelfDelivery> findByProdId(Long prodId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        return opProdCanDeliveryMapper.selectByExample(example);
    }

    private List<OpProdCanSelfDelivery> findByProdIdDistId(Long prodId, Long distId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        // int to long
        criteria.andDistrictIdEqualTo(distId);
        return opProdCanDeliveryMapper.selectByExample(example);
    }

    public boolean deleteByProdDistIds(Long prodId, List<Long> distIds) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        OpProdCanSelfDeliveryExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdEqualTo(prodId);
        criteria.andDistrictIdIn(distIds);
        return opProdCanDeliveryMapper.deleteByExample(example) != 0;
    }


    @Override
    public boolean deleteByProdId(Long prodId) {
        OpProdCanSelfDeliveryExample example = new OpProdCanSelfDeliveryExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        return opProdCanDeliveryMapper.deleteByExample(example) != 0;
    }
}
