package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpLabelCond;
import com.thebeastshop.pegasus.merchandise.dao.OpLabelMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpLabelDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCategoryDomain;
import com.thebeastshop.pegasus.merchandise.model.OpLabel;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCategory;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCategoryService;
import com.thebeastshop.pegasus.merchandise.vo.OpLabelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/12/29 14:22
 */
@Component("opLabelDomain")
public class OpLabelDomainImpl extends AbstractBaseDomain<OpLabelVO, OpLabel> implements OpLabelDomain {

    @Autowired
    private OpLabelMapper opLabelMapper;

    @Autowired
    private PcsSkuCategoryDomain pcsSkuCategoryDomain;

    @Autowired
    private McPcsSkuCategoryService mcPcsSkuCategoryService;


    @Override
    public List<OpLabelVO> findByCondCategory(OpLabelCond cond) {
        String code = cond.getCategoryCode();
        List<Long> ids = new ArrayList();
        if(code != null) {
            List<PcsSkuCategoryVO> list = mcPcsSkuCategoryService.findByCodeAndRightLikeCode(code);
            for (PcsSkuCategoryVO obj : list) {
                ids.add(obj.getId());
            }
        }else{
            ids = cond.getCategoryIds();
        }
        cond.setCategoryIds(ids);
        return opLabelMapper.findByCondCategory(cond);
    }

    @Override
    public List<OpLabelVO> findByIds(OpLabelCond cond) {
        return opLabelMapper.findByIds(cond);
    }

}
