/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpChnCanSaleProdCond;
import com.thebeastshop.pegasus.merchandise.dao.OpChnCanSaleProdMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.BaseDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpChnCanSaleProdDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.exception.OperationExceptionErrorCode;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProdExample;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:27
 */
@Component("opChnCanSaleProdDomain")
public class OpChnCanSaleProdDomainImpl extends AbstractBaseDomain<OpChnCanSaleProdVO, OpChnCanSaleProd>
        implements OpChnCanSaleProdDomain {

    @Autowired
    private OpChnCanSaleProdMapper opChannelCanSaleSkuMapper;
    @Autowired
    private OpProdSkuDomain opProdSkuDomain;
    @Autowired
    OpProductMapper opProductMapper;
    @Autowired
    OpProductDomain opProductDomain;

    /**
     * 根据渠道编码查找
     *
     * @param channelCode 渠道编码
     * @return
     */
    @Override
    public List<OpChnCanSaleProd> findByChannelCode(String channelCode) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andChannelCodeEqualTo(channelCode);
        return opChannelCanSaleSkuMapper.selectByExample(example);
    }

    @Override
    public boolean deleteById(Long id) {
        return opChannelCanSaleSkuMapper.deleteByPrimaryKey(id) != 0;
    }

    /**
     * 根据渠道编码 删除可售SKU
     *
     * @param channelCode
         */
        @Override
        public void deleteByChannelCode(String channelCode) {
            OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
            example.createCriteria().andChannelCodeEqualTo(channelCode);
            opChannelCanSaleSkuMapper.deleteByExample(example);
        }

    /**
     * @param channelCode
     * @param prodId
     * @return
     */
    @Override
    public List<OpChnCanSaleProd> findByChannelCodeProdId(String channelCode, Long prodId) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andChannelCodeEqualTo(channelCode);
        criteria.andProductIdEqualTo(prodId);
        return opChannelCanSaleSkuMapper.selectByExample(example);
    }

    @Override
    public boolean create(OpChnCanSaleProd prod) {
        if (CollectionUtils.isNotEmpty(findByChannelCodeProdId(prod.getChannelCode(), prod.getProductId()))) {
            return false;
//            OpProduct opProduct = opProductMapper.selectByPrimaryKey(prod.getProductId());
//            throw new Operati  onException(OperationExceptionErrorCode.DUPLICATE_CAN_SALE_PROD_CODE, "渠道编码: "+prod.getChannelCode()+",已经存在此PROD："+ opProduct.getCode());
        } else {
            Long productId = prod.getProductId();
            OpProduct opProduct = opProductMapper.selectByPrimaryKey(productId);
            List<String> list = new ArrayList<String>();
            //组合商品逻辑
            if (opProduct.getCombined()) {
                OpProductVO productVO = opProductDomain.findCombinedProductByProdId(productId);
                List<OpSpvVO> opSpvs = productVO.getSpvList();
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(opSpvs)) {
                    for (OpSpvVO spvVO : opSpvs) {
                        List<PcsSkuCombinationVO> scList = spvVO.getSkuCombinationList();
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(scList)) {
                            for (PcsSkuCombinationVO vo : scList) {
                                String skuCode = vo.getSubSkuCode();
                                list.add(skuCode);
                            }
                        }
                        list = new ArrayList<String>(new LinkedHashSet<String>(list));
                    }
                }
                if (CollectionUtils.isNotEmpty(list)) {
                    StringBuilder skuCodes = new StringBuilder();
                    for (String sku : list) {
                        skuCodes.append(",").append(sku);
                    }
                    prod.setCanSaleSku(skuCodes.substring(1).toString());
                    prod.setCanSeeSku(prod.getCanSaleSku());
                }
            } else {
                List<OpProdSku> skus = opProdSkuDomain.findByProdId(prod.getProductId());
                if (CollectionUtils.isNotEmpty(skus)) {
                    StringBuilder skuCodes = new StringBuilder();
                    for (OpProdSku sku : skus) {
                        skuCodes.append(",").append(sku.getSkuCode());
                    }
                    prod.setCanSaleSku(skuCodes.substring(1).toString());
                    prod.setCanSeeSku(skuCodes.substring(1).toString());
                }
            }
            return opChannelCanSaleSkuMapper.insert(prod) != 0;
        }
    }

    @Override
    public boolean update(OpChnCanSaleProd prod) {
        return opChannelCanSaleSkuMapper.updateByPrimaryKeySelective(prod) != 0;
    }

    @Override
    public List<OpChnCanSaleProdVO> findByCond(OpChnCanSaleProdCond cond) {
        return opChannelCanSaleSkuMapper.findVOByCond(cond);
    }

    @Override
    public List<OpChnCanSaleProdVO> findByProdIds(List<Long> prodIds) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        OpChnCanSaleProdExample.Criteria criteria = example.createCriteria();
        criteria.andProductIdIn(prodIds);
        example.setOrderByClause("PRODUCT_ID");
        return BeanUtil.buildListFrom(opChannelCanSaleSkuMapper.selectByExample(example), OpChnCanSaleProdVO.class);
    }

    @Override
    public OpChnCanSaleProdVO findById(Long id) {
        return BeanUtil.buildFrom(opChannelCanSaleSkuMapper.selectByPrimaryKey(id), OpChnCanSaleProdVO.class);
    }


    @Override
    public void deleteByProdId(Long prodId) {
        OpChnCanSaleProdExample example = new OpChnCanSaleProdExample();
        example.createCriteria().andProductIdEqualTo(prodId);
        opChannelCanSaleSkuMapper.deleteByExample(example);
    }
}
