package com.thebeastshop.pegasus.merchandise.domain.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpAttributeCond;
import com.thebeastshop.pegasus.merchandise.dao.OpAttributeMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeDomain;
import com.thebeastshop.pegasus.merchandise.domain.OpAttributeValueDomain;
import com.thebeastshop.pegasus.merchandise.model.OpAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeExample;
import com.thebeastshop.pegasus.merchandise.model.OpAttributeValue;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeValueVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 *
 * @author gongjun
 * @since 2016-10-17
 */
@Component("opAttributeDomain")
public class OpAttributeDomainImpl extends AbstractBaseDomain<OpAttributeVO, OpAttribute> implements OpAttributeDomain {

    @Autowired
    private OpAttributeMapper opAttributeMapper;

    @Autowired
    private OpAttributeValueDomain opAttributeValueDomain;

    @Override
    public int create(OpAttribute attribute) {
        attribute.setActive(true);
        attribute.setCreateTime(new Date());
        attribute.setUpdateTime(new Date());
        return opAttributeMapper.insert(attribute);
    }

    @Override
    public int createWithValues(OpAttributeVO attrVO) {
        OpAttribute attr = buildFromVO(attrVO);
        int ret = create(attr);
        if (ret == 0) {
            return 0;
        }
        attrVO.setId(attr.getId());
        List<OpAttributeValueVO> attrValueList = attrVO.getAttributeValueList();
        if (CollectionUtils.isNotEmpty(attrValueList)) {
            for (int i = 0; i < attrValueList.size(); i++) {
                OpAttributeValueVO attrValueVO = attrValueList.get(i);
                attrValueVO.setAttributeId(attrVO.getId());
                OpAttributeValue attrValue = opAttributeValueDomain.buildFromVO(attrValueVO);
                ret += opAttributeValueDomain.create(attrValue);
                attrValueVO.setId(attrValue.getId());
                attrVO.getAttributeValueMap().put(attrValueVO.getValueText(), attrValueVO);
            }
        }
        return ret;
    }

    @Override
    public boolean updateWithValues(OpAttributeVO attrVO) {
        OpAttribute attribute = buildFromVO(attrVO);
        int flag = opAttributeMapper.updateByPrimaryKeySelective(attribute);
        if( flag < 1){
            return false;
        }

        List<OpAttributeValueVO> attrValueList = attrVO.getAttributeValueList();
        if (CollectionUtils.isNotEmpty(attrValueList)) {
            for (int i = 0; i < attrValueList.size(); i++) {
                OpAttributeValueVO attrValueVO = attrValueList.get(i);
                OpAttributeValue attrValue = new OpAttributeValue();
                attrValue.setValueText(attrValueVO.getValueText());
                attrValue.setId(attrValueVO.getId());
                int ret = opAttributeValueDomain.update(attrValue);
                if(ret < 1){
                    return false;
                }
                attrVO.getAttributeValueMap().put(attrValueVO.getValueText(), attrValueVO);
            }
        }
        return true;
    }

    @Override
    public Boolean update(OpAttribute attributeVO) {
        return null;
    }

    @Override
    public OpAttribute getById(Long id) {
        return null;
    }

    @Override
    public List<OpAttributeVO> findByCondition(OpAttributeCond cond) {
        OpAttributeExample example = new OpAttributeExample();
        OpAttributeExample.Criteria criteria = example.createCriteria();
        if (cond.getId() != null) {
            criteria.andIdEqualTo(cond.getId());
        }
        if (cond.getProductId() != null) {
            criteria.andProductIdEqualTo(cond.getProductId());
        }
        if (cond.getCombined() != null) {
            criteria.andCombinedEqualTo(cond.getCombined() == true ? 1 : 0);
        }
        if (cond.getActive() != null) {
            criteria.andActiveEqualTo(cond.getActive());
        }
        List<OpAttribute> list = opAttributeMapper.selectByExample(example);
        List<OpAttributeVO> attributeList = buildFromModelList(list);
        for (OpAttributeVO attributeVO : attributeList) {
            List<OpAttributeValueVO> attrValueList =
                    opAttributeValueDomain.findOpAttributeValueByAttributeId(attributeVO.getId());
            attributeVO.setAttributeValueList(attrValueList);
        }
        return attributeList;
    }

}
