/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.domain;


import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface PsSkuDomain {
    boolean create(PsSkuVO vo);
    boolean create(List<PsSkuVO> vos);

    boolean update(PsSkuVO vo);

    boolean update(List<PsSkuVO> vos);

    boolean deleteBySkuCode(String skuCode);

    List<PsSkuVO> findAll();

    List<PsSkuVO> findBySkuName(String name);

    PsSkuVO findBySkuCode(String code);
    List<PsSkuVO> findBySkuCodes(List<String> codes);
    List<PsSkuVO> findBySuppIds(List<Long> suppIds);
    List<PsSkuVO> findByBrandIds(List<Long> brandIds);
    List<PsSkuVO> findByCateIds(List<Long> cateIds);

    List<PsSkuVO> findByCond(PsSkuCond cond);


    List<PsSkuVO> findByCodeName(String codeName);
    List<PsSkuVO> findByCodeName(String codeName, Integer currpage, Integer pagenum);

	Map<String, PsSkuVO> mapBySkuCodes(List<String> codes);

    List<PcsSkuVO> findSkuBySupplierId(Long supplierId);

}
