package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsTagCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuTag;
import com.thebeastshop.pegasus.merchandise.model.ProdTag;
import com.thebeastshop.pegasus.merchandise.vo.PcsTagVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsTagDomain {

    int addTag(PcsTagVO tagVO);

    int updateTag(PcsTagVO tagVO);

    PcsTagVO findTagById(Long id);

    int saveOrUpdateSkuTag(PcsSkuTag skuTag);

    List<PcsTagVO> queryTagList(Map<String, Object> params);
    
    List<PcsTagVO> queryTagListByProdId(Long prodId);

    List<ProdSkuVO> queryProdTagListByTagCode(PcsTagCond cond);

    List<ProdSkuVO> queryProdSkuListByTagParams(List<String> params);

    int updateProdTagByCodeList(ProdSkuVO prod, List<String> codeList,boolean isEmptyBeforeUpdate);

    int saveOrUpdateProdTag(ProdTag prodTag);

    int deleteProdTagByIds(List<String> idList);

}
