package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.ApprovalRecordCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuQualifyCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuQualify;
import com.thebeastshop.pegasus.merchandise.model.PcsSupplier;
import com.thebeastshop.pegasus.merchandise.vo.ApprovalRecordVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuQualifyVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;

import java.util.List;

public interface PcsSkuQualifyDomain {


    /**
     * vo转成model
     *
     * @param vo
     * @return
     */
    PcsSkuQualify buildFromVO(PcsSkuQualifyVO vo);

    /**
     * model转成vo
     * @param record
     * @return
     */
    PcsSkuQualifyVO buildFromModel(PcsSkuQualify record);

    /**
     * 创建SKU资质审批
     * @param record
     * @return
     */
    Long create(PcsSkuQualify record);

    /**
     * 更新SKU资质审批
     * @param record
     * @return
     */
    Boolean update(PcsSkuQualify record);

    /**
     * 根据ID查找SKU资质审批
     * @param id
     * @return
     */
    PcsSkuQualify findById(Long id);

    /**
     * 根据条件查找SKU资质审批
     * @param cond
     * @return
     */
    List<PcsSkuQualifyVO> findByCond(PcsSkuQualifyCond cond);

    /**
     * 根据条件查找SKU资质审批
     * @param cond
     * @return
     */
    List<PcsSkuQualify> findByCriteria(PcsSkuQualifyCond cond);

    /**
     * 根据skuCode查找SKU资质审批
     * @param name
     * @return
     */
    PcsSkuQualify findBySkuCode(String skuCode);

    /**
     * 根据id集合查找SKU资质审批
     * @param ids
     * @return
     */
    List<PcsSkuQualify> findByIds(List<Long> ids);

    /**
     * 供应SKU资质
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditSkuQualify(Long userId, long id, Boolean isPass, Integer type);
    
    Boolean auditSkuQualify(long id, Boolean isPass, Integer type);

    Boolean auditSkuQualify(ApprovalRecordVO vo, Boolean isPass,Integer importedType);
    
    long countByCond(PcsSkuQualifyCond cond);

	boolean createApprovalRecord(ApprovalRecordVO vo);

	List<ApprovalRecordVO> findApprovalRecordsByCond(ApprovalRecordCond cond);

    long getFileCountByCond(PcsSkuQualifyCond cond);
}
