package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCombinationCond;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCombination;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCombinationVO;

import java.util.List;

/**
 * SKU组合
 * @author gongjun
 * @since 2016-10-19
 */
public interface PcsSkuCombinationDomain extends BaseDomain<PcsSkuCombinationVO, PcsSkuCombination> {

    boolean create(PcsSkuCombination skuCombination);

    boolean update(PcsSkuCombination skuCombination);

    /**
     * 根据spvId查询相关信息
     * @param cond
     * @return
     */
    List<PcsSkuCombinationVO> findSkuCombinationBySpvId(PcsSkuCombinationCond cond);

    List<PcsSkuCombination> findBySpvId(Long spvId);

    List<PcsSkuCombination> findBySpvIdAndCode(Long spvId,String code);

    /**
     * 查SPV组合信息
     * @param spvId
     * @return
     */
    List<PcsSkuCombinationVO> findSkuCombinationBySpvId(Long spvId);

}
