package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.model.PcsQualification;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;

import java.util.List;

public interface PcsQualificationDomain {


    /**
     * vo转成model
     *
     * @param vo
     * @return
     */
    PcsQualification buildFromVO(PcsQualificationVO vo);

    /**
     * model转成vo
     * @param record
     * @return
     */
    PcsQualificationVO buildFromModel(PcsQualification record);

    /**
     * 创建SKU资质文件
     * @param record
     * @return
     */
    Long create(PcsQualification record);

    /**
     * 删除SKU资质文件
     * @param vo
     * @return
     */
    int deleteByPrimaryKey(Long id);
    
    /**
     * 删除SKU资质文件
     * @param vo
     * @return
     */
    Long deleteByQualifyId(Long qualifyId);
    
    /**
     * 更新SKU资质文件
     * @param record
     * @return
     */
    Boolean update(PcsQualification record);

    /**
     * 根据ID查找SKU资质文件
     * @param id
     * @return
     */
    PcsQualification findById(Long id);
    
    /**
     * 根据qualifyId查找SKU资质文件
     * @param name
     * @return
     */
    List<PcsQualification> findByQualifyId(Long qualifyId);

    /**
     * 根据条件查找SKU资质文件
     * @param cond
     * @return
     */
    List<PcsQualificationVO> findByCond(PcsQualificationCond cond);

    /**
     * 根据条件查找SKU资质文件
     * @param cond
     * @return
     */
    List<PcsQualification> findByCriteria(PcsQualificationCond cond);

    /**
     * 根据id集合查找SKU资质文件
     * @param ids
     * @return
     */
    List<PcsQualification> findByIds(List<Long> ids);

    long countByCond(PcsQualificationCond cond);
}
