package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsImportDocCond;
import com.thebeastshop.pegasus.merchandise.model.PcsImportDoc;
import com.thebeastshop.pegasus.merchandise.vo.PcsImportDocVO;
import java.util.List;

public interface PcsImportDocDomain {


    /**
     * vo转成model
     *
     * @param vo
     * @return
     */
    PcsImportDoc buildFromVO(PcsImportDocVO vo);

    /**
     * model转成vo
     * @param record
     * @return
     */
    PcsImportDocVO buildFromModel(PcsImportDoc record);

    /**
     * 创建SKU进口单证
     * @param record
     * @return
     */
    Long create(PcsImportDoc record);

    /**
     * 删除SKU进口单证
     * @param vo
     * @return
     */
     int deleteByPrimaryKey(Long id);
    
    /**
     * 删除SKU进口单证
     * @param vo
     * @return
     */
    Long deleteByQualifyId(Long qualifyId);
    
    /**
     * 更新SKU进口单证
     * @param record
     * @return
     */
    Boolean update(PcsImportDoc record);

    /**
     * 根据ID查找SKU进口单证
     * @param id
     * @return
     */
    PcsImportDoc findById(Long id);
    
    /**
     * 根据qualifyId查找SKU进口单证
     * @param name
     * @return
     */
    List<PcsImportDoc> findByQualifyId(Long qualifyId);

    /**
     * 根据条件查找SKU进口单证
     * @param cond
     * @return
     */
    List<PcsImportDocVO> findByCond(PcsImportDocCond cond);

    /**
     * 根据条件查找SKU进口单证
     * @param cond
     * @return
     */
    List<PcsImportDoc> findByCriteria(PcsImportDocCond cond);

    /**
     * 根据id集合查找SKU进口单证
     * @param ids
     * @return
     */
    List<PcsImportDoc> findByIds(List<Long> ids);

    long countByCond(PcsImportDocCond cond);
}
