package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriter;
import com.thebeastshop.pegasus.merchandise.model.PcsCopywriter;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;

import javax.management.OperationsException;
import java.util.List;
import java.util.Map;

/**
 * Created by QTJ on 2017/6/12.
 */
public interface PcsCopywriterDomain {
    //返回主键
    int addCopywriter(PcsCopywriter pcsCopywriter);

    int updateCopywriter(PcsCopywriterVO copywriterVO);

    int updateProdCopywriterByCodeList(ProdSkuVO prod, List<String> copywriterCodeList, boolean isEmptyBeforeUpdate);

    int saveOrUpdateProdCopywriter(OpProdCopywriter opProdCopywriter) throws OperationsException;

    PcsCopywriterVO findCopywriterById(Long id);

    List<ProdSkuVO> queryProdCopywriterList(PcsCopywriterCond cond);

    int deleteProdCopywriterByIds(List<String> idList);

    List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(PcsCopywriterCond cond);

    ProdSkuVO queryProductByProdCode(String prodCode);

    //更新文案状态
    void updateCopywriterValidStatus();

    /**
     * 通过ProdCodes查询 可以使用的文案
     * @param codes
     * @return
     */
    Map<String,ProductCopywriterVO> selectProductCopywriterByProdCodes(List<String> codes);

    //更新商品文案表
    int updateActiveTrueCopywriter();
    //更新商品文案表
    int updateActiveFalseCopywriter();

    /**
     * 更新文案表
     * @return
     */
    int updateValidStatusPendingEffect();
    int updateValidStatusAlreadyInForce();
    int updateValidStatusExpired();
}
