package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.OpSpvCond;
import com.thebeastshop.pegasus.merchandise.model.OpProdSku;
import com.thebeastshop.pegasus.merchandise.vo.OpAttributeVO;
import com.thebeastshop.pegasus.merchandise.vo.OpSpvVO;

import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface OpProdSkuDomain extends BaseDomain<OpSpvVO, OpProdSku> {

    /**
     * 创建SPV
     * @param prodSku
     * @return
     */
    boolean create(OpProdSku prodSku);

    /**
     * 创建组合SPV
     * @param attrIdMap
     * @param prodSkuVO
     * @return
     */
    boolean createCombinedSpv(Map<String , OpAttributeVO> attrIdMap, OpSpvVO prodSkuVO,Integer prodStatus);

    /**
    * 编辑组合SPV
    * @param prodSkuVO
    * @return
            */
    boolean updateCombinedSpv(OpSpvVO prodSkuVO,int temProdStatus,int prodStatus);

    boolean update(OpProdSku prodSku);

    boolean deleteById(Long id);

    boolean deleteByProdId(Long prodId);
    List<OpProdSku> findByProdId(Long prodId);
    List<OpProdSku> findByProdIds(List<Long> prodIds);
    List<OpProdSku> findBySkuCode(String skuCode);
    Integer getProductIdByskuCode(String skuCode);
    List<OpProdSku> findAll();
    List<String> getALLSkuCode();
    List<OpSpvVO> findByPcsProdSkuCond(OpSpvCond opSpvCond);
    List<OpSpvVO> findSpvCombinedByProdId(Long prodId);
    Boolean getSpvById(Long id);
}
