package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.OpChnCanSaleProdCond;
import com.thebeastshop.pegasus.merchandise.model.OpChnCanSaleProd;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:28
 */
public interface OpChnCanSaleProdDomain extends BaseDomain<OpChnCanSaleProdVO, OpChnCanSaleProd> {

    boolean create(OpChnCanSaleProd prod);

    boolean update(OpChnCanSaleProd prod);

    /**
     *
     * @param prodCode
     *@param chnCode
     * @param onshelf  1-onshelf  0-offshelf   @return
     */
//    boolean updateByProdCodeChnCode(String prodCode, String chnCode, int onshelf);

    /**
     * 根据渠道编码查找
     * @param channelCode  渠道编码
     * @return
     */
    List<OpChnCanSaleProd> findByChannelCode(String channelCode);

    boolean deleteById(Long id);

    /**
     * 根据渠道编码 删除可售SKU
     * @param channelCode
     */

    void deleteByChannelCode(String channelCode);

    /**
     *
     * @param channelCode
     * @param prodId
     * @return
     */
    List<OpChnCanSaleProd> findByChannelCodeProdId(String channelCode, Long prodId);

    List<OpChnCanSaleProdVO> findByCond(OpChnCanSaleProdCond cond);
    List<OpChnCanSaleProdVO> findByProdIds(List<Long> prodIds);

    OpChnCanSaleProdVO findById(Long id);

    void deleteByProdId(Long prodId);
}
