package com.thebeastshop.pegasus.merchandise.dao;

import com.thebeastshop.pegasus.merchandise.cond.PcsCopywriterCond;
import com.thebeastshop.pegasus.merchandise.model.OpProdCopywriter;
import com.thebeastshop.pegasus.merchandise.vo.PcsCopywriterVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductCopywriterVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Created by QTJ on 2017/6/12.
 */
public interface OpProdCopywriterCustomerMapper {
    int updateProdCopywriterDeleteByIds(Map<String, Object> params);

    int countOfProdCopywriter(OpProdCopywriter opProdCopywriter);

    List<ProdSkuVO> queryProdCopywriterList(@Param("cond") PcsCopywriterCond cond);

    ProdSkuVO queryProductByProdId(Long prodId);

    ProdSkuVO queryProductByProdCode(String prodCode);

    int updateProdCopywriter(OpProdCopywriter opProdCopywriter);

    List<PcsCopywriterVO> queryPcsCopywriterVOListByCond(@Param("cond") PcsCopywriterCond cond);

    /**
     * 通过ProdCodes查询 可以使用的文案
     * @param productCodes
     * @return
     */
    List<ProductCopywriterVO> selectProductCopywriterByProdCodes(@Param("productCodes") List<String> productCodes);

    int updateProductCopywriterUpdateTimeByCopyId(@Param("copywriterId") Long copywriterId);


    //更新商品文案表
    int updateActiveTrueCopywriter();
    //更新商品文案表
    int updateActiveFalseCopywriter();

    /**
     * 更新文案表
     * @return
     */
    int updateValidStatusPendingEffect();
    int updateValidStatusAlreadyInForce();
    int updateValidStatusExpired();
}
