package com.thebeastshop.pegasus.merchandise.client;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-03
 */
public class SpvESClient extends AbstractESClient<PsSpvVO> {

    @Autowired
    private CampaignESClient campaignClient;

    public SpvESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsSpvVO build(SearchHit hit, String chnCode) {
        Map<String, Object> params = hit.getSource();
        PsSpvVO spvVO = new PsSpvVO();
        buildSpv(params, spvVO);
        return spvVO;
    }

    public void buildSpv(Map<String, Object> params, PsSpvVO spvVO) {
        spvVO.setSpvId(MapUtils.getLong(params, "spvId"));
        spvVO.setProductId(MapUtils.getLong(params, "productId"));
        spvVO.setProductCode(MapUtils.getString(params, "prodCode"));
        if(MapUtils.getString(params, "salesPrice") != null){
            spvVO.setSalesPrice(new BigDecimal(MapUtils.getString(params, "salesPrice")));
        }
        Integer minAmount = MapUtils.getInteger(params, "minAmount");
        if (minAmount != null && minAmount.intValue() < 1) {
            minAmount = 1;
        }
        spvVO.setMinAmount(minAmount);
        String attrs = MapUtils.getString(params, "attrs");
        if (StringUtils.isNotEmpty(attrs)) {
            spvVO.setAttrs(attrs);
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONArray.parseArray(attrs);
            } catch (Exception ex) {}
            if (jsonArray != null) {
                Map<Long, Long> attrValues = new LinkedHashMap<>();
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONArray attrArr = jsonArray.getJSONArray(i);
                    if (attrArr.size() < 2) continue;
                    attrValues.put(attrArr.getLong(0), attrArr.getLong(1));
                }
                spvVO.setAttrValues(attrValues);
            }
        }

        List<Map> attributeValuePairList = (List<Map>) params.get("attributeValuePairList");
        if (CollectionUtils.isNotEmpty(attributeValuePairList)) {
            List<PsAttributeValuePairVO> pairVOs = new ArrayList<>();
            for (Map attributeValue : attributeValuePairList) {
                PsAttributeValuePairVO pair = new PsAttributeValuePairVO();
                pair.setAttrId(MapUtils.getLong(attributeValue, "attrId"));
                Integer combined = MapUtils.getInteger(attributeValue, "combined");
                if (combined == null) {
                    combined = 0;
                }
                pair.setCombined(combined == 0 ? false : true);
                pair.setGroupName(MapUtils.getString(attributeValue, "groupName"));
                pair.setAttrName(MapUtils.getString(attributeValue, "attrName"));
                pair.setAttrValueId(MapUtils.getLong(attributeValue, "attrValueId"));
                pair.setValue(MapUtils.getString(attributeValue, "value"));
                pairVOs.add(pair);
            }
            spvVO.setAttributeValuePairList(pairVOs);
        }

        Integer combined = MapUtils.getInteger(params, "combined");
        if (combined == null) {
            combined = 0;
        }
        spvVO.setCombined(combined == 0 ? false : true);
        // 单品的情况
        if (combined == 0) {
            // 查询单品SKU CODE
            spvVO.setSkuCode(MapUtils.getString(params, "skuCode"));
        }
        else { // 组合商品的情况
            List<Map> skuCombinationList = (List<Map>) params.get("skuCombinationList");
            if (CollectionUtils.isNotEmpty(skuCombinationList)) {
                List<PsSkuCombinationVO> skuCombinationVOs = new ArrayList<>();
                for (Map skuCombination : skuCombinationList) {
                    PsSkuCombinationVO skuCombinationVO = new PsSkuCombinationVO();
                    skuCombinationVO.setSubSkuCode(MapUtils.getString(skuCombination, "subSkuCode"));
                    skuCombinationVO.setQuantity(MapUtils.getInteger(skuCombination, "quantity"));
                    skuCombinationVOs.add(skuCombinationVO);
                }
                spvVO.setSkuCombinationList(skuCombinationVOs);
            }
        }
        List<Map> campaignList = (List<Map>) params.get("campaignList");
        if(CollectionUtils.isNotEmpty(campaignList)) {
            PsCampaignVO campaignVO;
            List<PsCampaignVO> spvCampaignList = Lists.newArrayList();
            for (Map campaign : campaignList) {
                campaignVO = new PsCampaignVO();
                campaignClient.buildCampaign(campaign, campaignVO);
                spvCampaignList.add(campaignVO);
            }
            spvVO.setCampaignList(spvCampaignList);
        }
    }

    @Override
    public PsSpvVO build(SearchHit hit, String chnCode, Long total) {
        PsSpvVO spvVO = build(hit, chnCode);
        return spvVO;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSpvVO vo) {
        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return "spvId";
    }

}
