/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

/**
 * @author Roy.Chen
 * @version $Id: SKUClient.java, v 0.1 2015-08-05 17:13
 */
public class SkuESClient extends AbstractESClient<PsSkuVO> {
    private static final Logger log = LoggerFactory.getLogger(SkuESClient.class);

    public SkuESClient(String index, String type, ElasticsearchClientFactory elasticsearchClientFactory) {
        super(index, type, elasticsearchClientFactory);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode) {
        return build(hit, chnCode, null);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode, Long total) {
        PsSkuVO vo = new PsSkuVO();
        try {
            Map<String, Object> params = hit.getSource();
            vo.setSkuId((Integer) params.get("skuId") + 0L);
            vo.setSkuCode((String) params.get("skuCode"));
            vo.setSkuName((String) params.get("skuName"));
            vo.setSkuNameCN((String) params.get("skuNameCN"));
            vo.setSkuType((Integer) params.get("skuType"));
            vo.setIsMadeBySelf((Integer) params.get("isMadeBySelf"));
            vo.setIsImported((Integer) params.get("isImported"));
            vo.setSkuCustomMadeCode((String) params.get("customMadeCode"));
//        List<String> smallIconList = (List<String>) params.get("smallIconList");
//        List<String> largeIconList = (List<String>) params.get("largeIconList");
//        List<Map<String, String >> tagList = (List<Map<String, String>>) params.get("tagList");
//        if (CollectionUtils.isNotEmpty(smallIconList)) {
//            vo.setSmallIconList(smallIconList);
//        }
//        if (CollectionUtils.isNotEmpty(largeIconList)) {
//            vo.setLargeIconList(largeIconList);
//        }
//        if (CollectionUtils.isNotEmpty(tagList)) {
//            vo.setTagList(makeTagList(tagList));
//        }
            vo.setCombinedSkuRecipeCode((String) params.get("combinedSkuRecipeCode"));
            vo.setEan13((String) params.get("ean13"));
            vo.setBarcode((String) params.get("barcode"));
            vo.setCanPurchase((Integer) params.get("canPurchase"));
            vo.setCanRemark((Integer) params.get("canRemark"));
            vo.setIsJit((Integer) params.get("isJit"));
            vo.setSalesPrice(MapUtils.getDoubleValue(params, "salesPrice"));
            vo.setCategoryId((Integer) params.get("categoryId") + 0L);
            vo.setCategoryName((String) params.get("categoryName"));
            vo.setBrandId(MapUtils.getLongValue(params, "brandId"));
            vo.setBrandName((String) params.get("brandName"));
            vo.setBrandNameCN((String) params.get("brandNameCN"));
            if(params.get("canCustomizeSalesPrice") != null){
                vo.setCanCustomizeSalesPrice((Integer) params.get("canCustomizeSalesPrice"));
            }
            if(params.get("saleEndDate") != null){
                String text = params.get("saleEndDate").toString();
                vo.setSaleEndDate(utcToDate(text));
            }
            if(params.get("skuStatus") != null){
                vo.setSkuStatus((Integer) params.get("skuStatus"));
            }
            if (params.get("brandCountryId") != null) {
                vo.setBrandCountryId((Integer) params.get("brandCountryId") + 0L);
            }
            if (params.get("brandCountryName") != null) {
                vo.setBrandCountryName((String) params.get("brandCountryName"));
            }
            vo.setCanCustomize(MapUtils.getInteger(params, "canCustomize"));
            vo.setCustomizeType(MapUtils.getInteger(params, "customizeType"));
            if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                if(MapUtils.getString(params, "customizationPrice") == null){
                    vo.setCustomizationPrice(new BigDecimal(0L));
                }else {
                    vo.setCustomizationPrice(new BigDecimal(MapUtils.getString(params, "customizationPrice")));
                }
                Map customize = (Map)params.get("customize");
                List<Map> colorElementMapList = (List<Map>) customize.get("colorElementList");
                List<Map> wordElementMapList = (List<Map>) customize.get("wordElementList");
                List<Map> customizeImageMapList = (List<Map>) customize.get("customizeImageList");
                List<PsCustomizeElementVO> colorElements = new ArrayList<>();
                List<PsCustomizeElementVO> wordElements = new ArrayList<>();
                List<PsCustomizeImageVO> customizeImages = new ArrayList<>();
                PsCustomizeVO customizeVO = new PsCustomizeVO();
                if (CollectionUtils.isNotEmpty(colorElementMapList)) {
                    for (Map colorElementMap : colorElementMapList) {
                        PsCustomizeElementVO customizationVO = new PsCustomizeElementVO();
                        customizationVO.setId(MapUtils.getLong(colorElementMap, "id"));
                        customizationVO.setDisplayName(MapUtils.getString(colorElementMap, "displayName"));
                        customizationVO.setPositionIcon(MapUtils.getString(colorElementMap, "positionIcon"));
                        customizationVO.setElementType(MapUtils.getInteger(colorElementMap, "elementType"));
                        customizationVO.setBgColor(MapUtils.getBoolean(colorElementMap, "bgColor") == null ? false : MapUtils.getBoolean(colorElementMap, "bgColor"));
                        String color = MapUtils.getString(colorElementMap, "color");
                        customizationVO.setColor(color);
                        List<PsCustomizeColorVO> colorVOs = new ArrayList<>();
                        List<List<String>> listObj = JSON.parseObject(color, List.class);
                        if(CollectionUtils.isNotEmpty(listObj)){
                            for(List<String> listVO : listObj){
                            	int colorSize = listVO.size();
                                PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                                colorVO.setColorName(listVO.get(0));
                                colorVO.setColorValue(listVO.get(1));
                                if(colorSize > 2) {
                                	 colorVO.setBackgroundColorValue(listVO.get(2));
                                     colorVO.setWordColorValue(listVO.get(3));
                                }
                                colorVOs.add(colorVO);
                            }
                        }
                        customizationVO.setColorList(colorVOs);
                        customizationVO.setIsmatch(MapUtils.getBoolean(colorElementMap, "ismatch"));
                        customizationVO.setParentId(MapUtils.getInteger(colorElementMap, "parentId"));
                        colorElements.add(customizationVO);
                    }
                    customizeVO.setColorElementList(colorElements);
                }
                if (CollectionUtils.isNotEmpty(wordElementMapList)) {
                    for (Map wordElementMap : wordElementMapList) {
                        PsCustomizeElementVO customizationVO = new PsCustomizeElementVO();
                        customizationVO.setId(MapUtils.getLong(wordElementMap, "id"));
                        customizationVO.setDisplayName(MapUtils.getString(wordElementMap, "displayName"));
                        customizationVO.setPositionIcon(MapUtils.getString(wordElementMap, "positionIcon"));
                        customizationVO.setElementType(MapUtils.getInteger(wordElementMap, "elementType"));
                        customizationVO.setColor(MapUtils.getString(wordElementMap, "color"));
                        customizationVO.setWordsLimit(MapUtils.getInteger(wordElementMap, "wordsLimit"));
                        customizationVO.setSupportType(MapUtils.getString(wordElementMap, "supportType"));
                        customizationVO.setIsmatch(MapUtils.getBoolean(wordElementMap, "ismatch"));
                        customizationVO.setParentId(MapUtils.getInteger(wordElementMap, "parentId"));
                        Map colorElement = (Map)wordElementMap.get("colorElement");
                        if(colorElement != null && colorElement.size() > 0){
                            PsCustomizeElementVO colorElementVO = new PsCustomizeElementVO();
                            Integer id = (Integer)colorElement.get("id");
                            colorElementVO.setId(id.longValue());
                            colorElementVO.setElementType((Integer) colorElement.get("elementType"));
                            colorElementVO.setPositionIcon((String) colorElement.get("positionIcon"));
                            colorElementVO.setDisplayName((String) colorElement.get("displayName"));
                            if(colorElement.get("parentId") != null) {
                                colorElementVO.setParentId((Integer) colorElement.get("parentId"));
                            }
                            Integer ismatch = (Integer)colorElement.get("ismatch");
                            colorElementVO.setIsmatch( 1 == ismatch ? true : false);
                            String color = (String) colorElement.get("color");
                            colorElementVO.setColor(color);
                            List<PsCustomizeColorVO> colorVOs = new ArrayList<>();
                            List<List<String>> ListObj = JSON.parseObject(color, List.class);
                            if(CollectionUtils.isNotEmpty(ListObj)){
                                for(List<String> listVO:ListObj){
                                    PsCustomizeColorVO colorVO = new PsCustomizeColorVO();
                                    colorVO.setColorName(listVO.get(0));
                                    colorVO.setColorValue(listVO.get(1));
                                    colorVOs.add(colorVO);
                                }
                            }
                            colorElementVO.setColorList(colorVOs);
                            customizationVO.setColorElement(colorElementVO);
                        }
                        wordElements.add(customizationVO);
                    }
                    customizeVO.setWordElementList(wordElements);
                }
                if (CollectionUtils.isNotEmpty(customizeImageMapList)) {
                    for (Map customizeImageMap : customizeImageMapList) {
                        PsCustomizeImageVO customizationVO = new PsCustomizeImageVO();
                        customizationVO.setId(MapUtils.getLong(customizeImageMap, "id"));
                        customizationVO.setImageUrl(MapUtils.getString(customizeImageMap, "imageUrl"));
                        String attr = MapUtils.getString(customizeImageMap, "attr");
                        customizationVO.setAttr(attr);
                        List<List> attrs = JSON.parseObject(attr, List.class);
                        customizationVO.setAttrs(attrs);
                        customizeImages.add(customizationVO);
                    }
                    customizeVO.setCustomizeImageList(customizeImages);
                }
                vo.setCustomize(customizeVO);
            }
            vo.setSupplierId((Integer) params.get("supplierId") + 0L);
            vo.setSupplierName((String) params.get("supplierName"));
            vo.setSupplierNameCN((String) params.get("supplierNameCN"));
            vo.setPlaceOfOrigin((String) params.get("placeOfOrigin"));
            vo.setSkuCateName((String) params.get("skuCategoryName"));
            vo.setPointDeductPoint(new BigDecimal(MapUtils.getString(params, "pointDeductPoint")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setPointDeductRule((Integer) params.get("pointDeductRule"));
            vo.setPointDuductPrice(new BigDecimal(MapUtils.getString(params, "pointDuductPrice")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setCostPrice(new BigDecimal(MapUtils.getString(params, "costPrice")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setCrossBorderFlag((Integer) params.get("crossBorderFlag"));
            if (params.get("clearanceWay") != null) {
                Integer bd = (Integer) params.get("clearanceWay");
                String db = bd + "";
                vo.setClearanceWay(Short.valueOf(db));
            }

            vo.setWeight((String) params.get("weight"));
            vo.setTaxNo((String) params.get("taxNo"));

            vo.setUpdateTime((String) params.get("updateTime"));
            vo.setWhetherConsignment((Integer) params.get("whetherConsignment"));
            vo.setIsMonthSend((Integer) params.get("isMonthSend"));
            vo.setDeliveryTimes((Integer) params.get("deliveryTimes"));
            vo.setMonthSendDeliveryRule((Integer) params.get("monthSendDeliveryRule"));
            if (params.get("deliveryPeriod") != null) {
                vo.setDeliveryPeriod((Integer) params.get("deliveryPeriod"));
            }
        } catch (Exception ex) {
            log.error("Build SKU Error: ", ex);
            throw ex;
        }
        return vo;
    }

    private List<PsTagVO> makeTagList(List<Map<String, String>> list) {
        List<PsTagVO> results = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            Map<String, String> map = list.get(i);
            String icon = map.get("icon");
            String text = map.get("text");
            PsTagVO tagVO = new PsTagVO();
            tagVO.setIcon(icon);
            tagVO.setText(text);
            results.add(tagVO);
        }
        return results;
    }

    private List<Map<String, String>> makeTagMapList(List<PsTagVO> voList) {
        if (voList == null || voList.isEmpty()) {
            return ListUtils.EMPTY_LIST;
        }
        List<Map<String, String>> mapList = new ArrayList<>();
        for (int i = 0; i < voList.size(); i++ ) {
            PsTagVO vo = voList.get(i);
            Map<String, String> map = new HashMap<>();
            map.put("icon", vo.getIcon());
            map.put("text", vo.getText());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSkuVO vo) {
        try {
        XContentBuilder builder = jsonBuilder();

            builder.startObject()
                    //必须设置 方便删除更新
                    .field("id", vo.getSkuCode())
                    .field("skuId", vo.getSkuId())
                    .field("skuCode", vo.getSkuCode())
                    .field("skuName", vo.getSkuName())
                    .field("skuNameCN", vo.getSkuNameCN())
                    .field("skuType", vo.getSkuType())
                    .field("isMadeBySelf", vo.getIsMadeBySelf())
                    .field("isImported", vo.getIsImported())
                    //.field("smallIconList", vo.getSmallIconList())
                    //.field("largeIconList", vo.getLargeIconList())
                    //.field("tagList", makeTagMapList(vo.getTagList()))
                    .field("skuCustomMadeCode", avoidNull(vo.getSkuCustomMadeCode()))
                    .field("combinedSkuRecipeCode", avoidNull(vo.getCombinedSkuRecipeCode()))
                    .field("isSkuCustomMade", vo.getIsSkuCustomMade())
                    .field("isCombinedSkuRecipeCode", vo.getIsCombinedSkuRecipeCode())
                    .field("ean13", avoidNull(vo.getEan13()))
                    .field("barcode", avoidNull(vo.getBarcode()))
                    .field("canPurchase", vo.getCanPurchase())
                    .field("salesPrice", vo.getSalesPrice())
                    .field("categoryId", NumberUtil.avoidNull(vo.getCategoryId()))
                    .field("categoryName", avoidNull(vo.getCategoryName()))
                    .field("brandId", NumberUtil.avoidNull(vo.getBrandId()))
                    .field("brandName", vo.getBrandName())
                    .field("brandNameCN", vo.getBrandNameCN())
                    .field("brandCountryId", vo.getBrandCountryId())
                    .field("brandCountryName", vo.getBrandCountryName())
                    .field("skuCategoryName", vo.getSkuCateName())
                    .field("canRemark", vo.getCanRemark())
                    .field("placeOfOrigin", vo.getPlaceOfOrigin())
                    .field("isJit", vo.getIsJit())
                    .field("supplierId", NumberUtil.avoidNull(vo.getSupplierId()))
                    .field("supplierName", avoidNull(vo.getSupplierName()))
                    .field("supplierNameCN", avoidNull(vo.getSupplierNameCN()))
                    .field("pointDeductPoint", vo.getPointDeductPoint())
                    .field("pointDeductRule", vo.getPointDeductRule())
                    .field("pointDuductPrice", vo.getPointDuductPrice())
                    .field("costPrice", vo.getCostPrice())
                    .field("updateTime", vo.getUpdateTime())
                    .field("crossBorderFlag", vo.getCrossBorderFlag())
                    .field("clearanceWay", vo.getClearanceWay())
                    .field("weight", vo.getWeight())
                    .field("taxNo", vo.getTaxNo())
                    .endObject();
        return builder;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String avoidNull(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getPrimaryKeyName() {
        return "skuCode";
    }

    private Date utcToDate(String s){
        s = s.replace('T', ' ');
        s = s.replace("Z", "");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(s);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR, 8);
        date = calendar.getTime();
        return date;
    }
}
