/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpProdSkuAttributeInfoCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeLineMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeMapper;
import com.thebeastshop.pegasus.merchandise.dao.OpProdSkuAttributeRelationMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProdSkuAttributeDomain;
import com.thebeastshop.pegasus.merchandise.enums.OpProdSkuAttributeLineStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.OpProdSkuAttributeStatusEnum;
import com.thebeastshop.pegasus.merchandise.exception.OperationException;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttribute;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeLine;
import com.thebeastshop.pegasus.merchandise.model.OpProdSkuAttributeRelation;
import com.thebeastshop.pegasus.merchandise.service.OpProdSkuAttributeService;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeLineInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationInfo;
import com.thebeastshop.pegasus.merchandise.vo.OpProdSkuAttributeRelationVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="opProdSkuAttributeService")
public class OpProdSkuAttributeServiceImpl
implements OpProdSkuAttributeService {
    @Autowired
    private OpProdSkuAttributeDomain opProdSkuAttributeDomain;
    @Autowired
    private OpProdSkuAttributeRelationMapper opProdSkuAttributeRelationMapper;
    @Autowired
    private OpProdSkuAttributeMapper opProdSkuAttributeMapper;
    @Autowired
    private OpProdSkuAttributeLineMapper opProdSkuAttributeLineMapper;

    @Transactional
    public int addOrUpdateProdSkuAttribute(OpProdSkuAttributeInfo opProdSkuAttributeInfo) {
        OpProdSkuAttribute opProdSkuAttribute = new OpProdSkuAttribute();
        BeanUtils.copyProperties((Object)opProdSkuAttributeInfo, (Object)opProdSkuAttribute);
        Integer attributeId = opProdSkuAttribute.getId();
        List newLines = opProdSkuAttributeInfo.getLineList();
        if (attributeId == null) {
            opProdSkuAttribute.setGmtCreate(new Date());
            this.opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
            attributeId = opProdSkuAttribute.getId();
            opProdSkuAttribute.setAttributeCode(this.generateCode(attributeId));
            this.opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
        } else {
            List<OpProdSkuAttributeLine> oldLines = this.opProdSkuAttributeDomain.findLineByAttributeId(attributeId);
            this.opProdSkuAttributeDomain.deleteByLineIds(this.findDeleteLines(newLines, oldLines));
            this.opProdSkuAttributeDomain.saveOpProdSkuAttribute(opProdSkuAttribute);
        }
        this.opProdSkuAttributeDomain.saveOpProdSkuAttributeLine(this.convertLineInfo2DO(opProdSkuAttributeInfo.getLineList(), attributeId, opProdSkuAttributeInfo.getCategoryId()));
        return 1;
    }

    private List<Integer> findDeleteLines(List<OpProdSkuAttributeLineInfo> newLines, List<OpProdSkuAttributeLine> oldLines) {
        ArrayList<Integer> lineIdList = new ArrayList<Integer>();
        for (OpProdSkuAttributeLine oldLine : oldLines) {
            Integer oldLineId = oldLine.getId();
            boolean isDel = true;
            for (OpProdSkuAttributeLineInfo newLine : newLines) {
                if (!oldLineId.equals(newLine.getId())) continue;
                isDel = false;
                break;
            }
            if (!isDel) continue;
            lineIdList.add(oldLineId);
        }
        return lineIdList;
    }

    private String generateCode(Integer id) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PROD_ATTRIBUTE_CODE", params);
        return code;
    }

    private List<OpProdSkuAttributeLine> convertLineInfo2DO(List<OpProdSkuAttributeLineInfo> lineInfoList, Integer attributeId, Integer categoryId) {
        if (EmptyUtil.isEmpty(lineInfoList)) {
            throw new OperationException("OP0001", "\u5c5e\u6027\u503c\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\uff01");
        }
        if (EmptyUtil.isEmpty((Object)attributeId)) {
            throw new OperationException("OP0001", "\u53c2\u6570\u5f02\u5e38");
        }
        if (EmptyUtil.isEmpty((Object)categoryId)) {
            throw new OperationException("OP0001", "\u53c2\u6570\u5f02\u5e38");
        }
        ArrayList<OpProdSkuAttributeLine> lineList = new ArrayList<OpProdSkuAttributeLine>();
        for (OpProdSkuAttributeLineInfo lineInfo : lineInfoList) {
            OpProdSkuAttributeLine line = new OpProdSkuAttributeLine();
            BeanUtils.copyProperties((Object)lineInfo, (Object)line);
            line.setAttributeId(attributeId);
            line.setCategoryId(categoryId);
            if (line.getId() != null) {
                OpProdSkuAttributeLine opProdSkuAttributeLine = this.opProdSkuAttributeLineMapper.selectByPrimaryKey(line.getId());
                if (opProdSkuAttributeLine != null) {
                    Byte lineStatus = opProdSkuAttributeLine.getLineStatus();
                    if (lineStatus == OpProdSkuAttributeLineStatusEnum.REJECT.status) {
                        line.setLineStatus(OpProdSkuAttributeLineStatusEnum.REVIEW.status);
                    } else {
                        line.setLineStatus(null);
                    }
                }
            } else {
                line.setLineStatus(OpProdSkuAttributeLineStatusEnum.REVIEW.status);
            }
            lineList.add(line);
        }
        return lineList;
    }

    public int approvalProdSkuAttribute(Integer attributeId, boolean isPass) {
        OpProdSkuAttributeInfo attributeInfo = this.findInfoById(attributeId, false);
        if (isPass) {
            attributeInfo.setAttributeStatus(OpProdSkuAttributeStatusEnum.COMPLETED_REVIEW.status);
        } else {
            attributeInfo.setAttributeStatus(OpProdSkuAttributeStatusEnum.REJECT.status);
        }
        OpProdSkuAttribute opProdSkuAttribute = new OpProdSkuAttribute();
        BeanUtils.copyProperties((Object)attributeInfo, (Object)opProdSkuAttribute);
        this.opProdSkuAttributeDomain.updateProdSkuAttribute(opProdSkuAttribute);
        this.opProdSkuAttributeDomain.approvalProdSkuAttributeVal(attributeId, isPass);
        return 0;
    }

    public int associatedAttributes(String skuCode, List<Integer> attributeLineIds) {
        return 0;
    }

    public List<OpProdSkuAttributeInfo> findByCond(OpProdSkuAttributeInfoCond cond) {
        return this.opProdSkuAttributeDomain.findByCond(cond);
    }

    public OpProdSkuAttributeInfo findInfoById(Integer id, boolean cascaded) {
        OpProdSkuAttributeInfo attributeInfo = this.opProdSkuAttributeDomain.findById(id);
        if (attributeInfo != null && cascaded) {
            attributeInfo.setLineList(this.findLineByAttributeId(id));
        }
        return attributeInfo;
    }

    public List<OpProdSkuAttributeLineInfo> findLineByAttributeId(Integer attributeId) {
        List<OpProdSkuAttributeLine> lines = this.opProdSkuAttributeDomain.findLineByAttributeId(attributeId);
        ArrayList<OpProdSkuAttributeLineInfo> lineInfoList = new ArrayList<OpProdSkuAttributeLineInfo>();
        if (EmptyUtil.isNotEmpty(lines)) {
            for (OpProdSkuAttributeLine line : lines) {
                OpProdSkuAttributeLineInfo opProdSkuAttributeLineInfo = new OpProdSkuAttributeLineInfo();
                BeanUtils.copyProperties((Object)line, (Object)opProdSkuAttributeLineInfo);
                lineInfoList.add(opProdSkuAttributeLineInfo);
            }
        }
        return lineInfoList;
    }

    public int batchApprovalProdSkuAttribute(List<Integer> attributeIdList, boolean isPass) {
        if (EmptyUtil.isNotEmpty(attributeIdList)) {
            for (Integer attributeId : attributeIdList) {
                this.approvalProdSkuAttribute(attributeId, isPass);
            }
        }
        return 1;
    }

    public List<String> findAttributeNameByCategoryId(Integer categoryId) {
        return this.opProdSkuAttributeDomain.findAttributeNameByCategoryId(categoryId);
    }

    @Transactional
    public int delAttributeById(Integer attributeId) {
        if (EmptyUtil.isNotEmpty(this.opProdSkuAttributeDomain.findLineByAttributeIdAndStatus(attributeId, OpProdSkuAttributeLineStatusEnum.REVIEW.status.intValue()))) {
            throw new OperationException("\u5c5e\u6027\u4e2d\u5b58\u5728\u5ba1\u6279\u4e2d\u7684\u5c5e\u6027\u503c\uff0c\u65e0\u6cd5\u5220\u9664!");
        }
        this.releaseRelationByAttributeId(attributeId);
        this.opProdSkuAttributeLineMapper.deleteByAttributeId(attributeId);
        this.opProdSkuAttributeDomain.deleAttributeById(attributeId);
        return 1;
    }

    public List<OpProdSkuAttributeInfo> findAttributeAndLineByCategoryId(Integer categoryId, Integer lineStatus) {
        return this.opProdSkuAttributeDomain.findAttributeAndLineByCategoryId(categoryId, lineStatus);
    }

    public void setupSkuAttribute(String skuCode, List<Integer> attributeLineList) {
        if (attributeLineList != null) {
            for (Integer lineId : attributeLineList) {
                OpProdSkuAttributeRelation opProdSkuAttributeRelation = new OpProdSkuAttributeRelation();
                opProdSkuAttributeRelation.setAttributeLineId(lineId);
                opProdSkuAttributeRelation.setSkuCode(skuCode);
                this.opProdSkuAttributeDomain.insertSkuAttributeRelation(opProdSkuAttributeRelation);
            }
        }
    }

    @Transactional
    public void batchSetupSkuAttribute(List<OpProdSkuAttributeRelationVO> relationList, List<OpProdSkuAttributeRelationInfo> deleteRelationList) {
        if (relationList != null) {
            for (OpProdSkuAttributeRelationVO lineVO : relationList) {
                OpProdSkuAttributeRelation opProdSkuAttributeRelation = new OpProdSkuAttributeRelation();
                BeanUtils.copyProperties((Object)lineVO, (Object)opProdSkuAttributeRelation);
                this.opProdSkuAttributeDomain.insertSkuAttributeRelation(opProdSkuAttributeRelation);
            }
        }
        this.batchReleaseSkuAttribute(deleteRelationList);
    }

    public List<OpProdSkuAttributeRelationInfo> findAttributeLinesBySkuCode(String skuCode) {
        return this.opProdSkuAttributeRelationMapper.selectBySkuCode(skuCode);
    }

    public List<OpProdSkuAttributeLineInfo> findAttributeValByCond(OpProdSkuAttributeInfoCond cond) {
        return this.opProdSkuAttributeMapper.findAttributeValByCond(cond);
    }

    @Transactional
    public void batchReleaseSkuAttribute(List<OpProdSkuAttributeRelationInfo> relationList) {
        if (EmptyUtil.isNotEmpty(relationList)) {
            for (OpProdSkuAttributeRelationInfo opProdSkuAttributeRelationVO : relationList) {
                this.opProdSkuAttributeRelationMapper.releaseSkuAttributeRelation(opProdSkuAttributeRelationVO.getSkuCode(), opProdSkuAttributeRelationVO.getAttributeLineId());
            }
        }
    }

    public OpProdSkuAttributeInfo findRepeatAttribute(String attributeName, Integer categoryId) {
        List<OpProdSkuAttributeInfo> attributeList = this.opProdSkuAttributeMapper.findRepeatAttribute(attributeName, categoryId);
        if (attributeList != null && attributeList.size() > 0) {
            return attributeList.get(0);
        }
        return null;
    }

    public List<OpProdSkuAttributeLineInfo> findLineByAttributeIdAndStatus(Integer attributeId, Integer lineStatus) {
        List<OpProdSkuAttributeLine> lineList = this.opProdSkuAttributeDomain.findLineByAttributeIdAndStatus(attributeId, lineStatus);
        ArrayList<OpProdSkuAttributeLineInfo> lineInfoList = new ArrayList<OpProdSkuAttributeLineInfo>();
        if (EmptyUtil.isNotEmpty(lineList)) {
            for (OpProdSkuAttributeLine line : lineList) {
                OpProdSkuAttributeLineInfo opProdSkuAttributeLineInfo = new OpProdSkuAttributeLineInfo();
                BeanUtils.copyProperties((Object)line, (Object)opProdSkuAttributeLineInfo);
                lineInfoList.add(opProdSkuAttributeLineInfo);
            }
        }
        return lineInfoList;
    }

    public void releaseRelationByAttributeId(Integer attributeId) {
        List<OpProdSkuAttributeLine> lineList = this.opProdSkuAttributeLineMapper.findLineByAttributeId(attributeId);
        if (EmptyUtil.isNotEmpty(lineList)) {
            for (OpProdSkuAttributeLine line : lineList) {
                this.opProdSkuAttributeRelationMapper.releaseSkuAttributeRelation(null, line.getId());
            }
        }
    }
}

