/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsWatermarkCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsWatermarkDomain;
import com.thebeastshop.pegasus.merchandise.service.McPcsWatermarkService;
import com.thebeastshop.pegasus.merchandise.vo.PcsWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.ProdSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.ProductWatermarkVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/watermark")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="mcPcsWatermarkService")
public class McPcsWatermarkServiceImpl
implements McPcsWatermarkService {
    private static Logger log = LoggerFactory.getLogger(McPcsWatermarkServiceImpl.class);
    @Autowired
    private PcsWatermarkDomain pcsWatermarkDomain;

    @POST
    public Long addWatermark(PcsWatermarkVO watermarkVO) {
        this.pcsWatermarkDomain.addIcon(watermarkVO);
        return watermarkVO.getId();
    }

    @PUT
    public int updateWatermark(PcsWatermarkVO watermarkVO) {
        return this.pcsWatermarkDomain.updateIcon(watermarkVO);
    }

    public int updateSkuWatrmarkByCodeList(String skuCode, List<String> codeList) {
        return this.pcsWatermarkDomain.updateSkuWatrmarkByCodeList(skuCode, codeList);
    }

    public int updateProdWatrmarkByCodeList(ProdSkuVO prod, List<String> watermarkCodeList, boolean isEmptyBeforeUpdate) {
        return this.pcsWatermarkDomain.updateProdWatrmarkByCodeList(prod, watermarkCodeList, isEmptyBeforeUpdate);
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsWatermarkVO findWatermarkById(@PathParam(value="id") Long id) {
        log.info("-- findWatermarkById -- id:{}", (Object)id);
        return this.pcsWatermarkDomain.findWatermarkById(id);
    }

    @GET
    @Path(value="list/params")
    public List<PcsWatermarkVO> queryWatermarkList(PcsWatermarkCond cond) {
        return this.pcsWatermarkDomain.queryWatermarkList(cond);
    }

    @GET
    @Path(value="list/cond")
    public List<ProdSkuVO> queryProdWatermarkList(PcsWatermarkCond cond) {
        return this.pcsWatermarkDomain.queryProdWatermarkList(cond);
    }

    @GET
    @Path(value="list/prod/{id}")
    public List<ProdSkuVO> querySkuListByProd(@PathParam(value="id") Long prodId) {
        return this.pcsWatermarkDomain.querySkuListByProd(prodId);
    }

    @GET
    @Path(value="list/sku_code/{skuCode}")
    public List<ProdSkuVO> queryProdListBySkuCode(@PathParam(value="skuCode") String code) {
        return this.pcsWatermarkDomain.queryProdListBySkuCode(code);
    }

    public int deleteProdWatermarkByIds(List<String> idList) {
        return this.pcsWatermarkDomain.deleteProdWatermarkByIds(idList);
    }

    public List<ProdSkuVO> queryProdWatermarkListByParams(List<String> params) {
        return this.pcsWatermarkDomain.queryProdWatermarkListByParams(params);
    }

    public ProdSkuVO queryProductByProdId(Long prodId) {
        return this.pcsWatermarkDomain.queryProductByProdId(prodId);
    }

    public Map<String, ProductWatermarkVO> seleckWatermarkByProductCodes(List<String> productCodes) {
        return this.pcsWatermarkDomain.seleckWatermarkByProductCodes(productCodes);
    }

    public int setProdWatermarkValidityByIds(Map<String, Object> params) {
        Date validStartTime = (Date)params.get("validStartTime");
        Date validEndTime = (Date)params.get("validEndTime");
        Date now = new Date();
        if (validStartTime.after(now) || validEndTime.before(now)) {
            params.put("active", 0);
        } else {
            params.put("active", 1);
        }
        return this.pcsWatermarkDomain.setProdWatermarkValidityByIds(params);
    }

    public int checkProdWatermarkHasValid(String watermarkCode, String skuCode) {
        return this.pcsWatermarkDomain.checkProdWatermarkHasValid(watermarkCode, skuCode);
    }

    public void updateActiveWatermark() {
        this.pcsWatermarkDomain.updateActiveFalseWatermark();
        this.pcsWatermarkDomain.updateActiveTrueWatermark();
    }
}

