/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCmSplDomain;
import com.thebeastshop.pegasus.merchandise.domain.PcsSkuCustomMadeDomain;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCmSpl;
import com.thebeastshop.pegasus.merchandise.model.PcsSkuCustomMade;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuCustomMadeService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Path(value="/sku/custom_made")
@Consumes(value={"application/json; charset=UTF-8"})
@Produces(value={"application/json; charset=UTF-8"})
@Service(value="pcsSkuCustomMadeService")
public class McPcsSkuCustomMadeServiceImpl
implements McPcsSkuCustomMadeService {
    @Autowired
    private PcsSkuCustomMadeDomain pcsSkuCustomMadeDomain;
    @Autowired
    private PcsSkuCmSplDomain pcsSkuCmSplDomain;

    public PcsSkuCustomMadeVO create(PcsSkuCustomMadeVO record) {
        PcsSkuCustomMade customMade = this.pcsSkuCustomMadeDomain.create((PcsSkuCustomMade)this.pcsSkuCustomMadeDomain.buildFromVO(record));
        return (PcsSkuCustomMadeVO)this.pcsSkuCustomMadeDomain.buildFromModel(customMade);
    }

    public boolean update(PcsSkuCustomMadeVO record) {
        return this.pcsSkuCustomMadeDomain.update((PcsSkuCustomMade)this.pcsSkuCustomMadeDomain.buildFromVO(record));
    }

    @GET
    @Path(value="{id:\\d+}")
    public PcsSkuCustomMadeVO findSkuCustomMadeById(@PathParam(value="id") long id) {
        return this.pcsSkuCustomMadeDomain.findSkuCustomMadeById(id);
    }

    public PcsSkuCustomMadeVO findById(long id) {
        return null;
    }

    public PcsSkuCustomMadeVO findSkuCustomMadeByCode(String code) {
        return null;
    }

    public List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond) {
        return this.pcsSkuCustomMadeDomain.findSkuCustomMadeByCond(cond);
    }

    @POST
    public Boolean createCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = (PcsSkuCustomMade)this.pcsSkuCustomMadeDomain.buildFromVO(pcsSkuCustomMadeVO);
        ArrayList<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = (PcsSkuCmSpl)this.pcsSkuCmSplDomain.buildFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return this.pcsSkuCustomMadeDomain.createCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    @PUT
    public Boolean updateCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO) {
        PcsSkuCustomMade pcsSkuCustomMade = (PcsSkuCustomMade)this.pcsSkuCustomMadeDomain.buildFromVO(pcsSkuCustomMadeVO);
        ArrayList<PcsSkuCmSpl> pcsSkuCmSplList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)pcsSkuCustomMadeVO.getSupplierList())) {
            pcsSkuCmSplList = Collections.emptyList();
        } else {
            for (PcsSkuCmSplVO pcsSkuCmSplVO : pcsSkuCustomMadeVO.getSupplierList()) {
                PcsSkuCmSpl pcsSkuCmSpl = (PcsSkuCmSpl)this.pcsSkuCmSplDomain.buildFromVO(pcsSkuCmSplVO);
                pcsSkuCmSplList.add(pcsSkuCmSpl);
            }
        }
        return this.pcsSkuCustomMadeDomain.updateCustomMadeAndLine(pcsSkuCustomMade, pcsSkuCmSplList);
    }

    @DELETE
    @Path(value="{id:\\d+}/sku_cm_qpl/{skuCmSplId}")
    public Boolean deletePcsCmSpl(@PathParam(value="id") long skuCustomMadeId, @PathParam(value="skuCmSplId") long skuCmSplId) {
        return this.pcsSkuCustomMadeDomain.deletePcsCmSpl(skuCustomMadeId, skuCmSplId);
    }

    public Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId) {
        return this.pcsSkuCustomMadeDomain.convertCustomMadeAndLine(skuCustomMadeId, skuCmSplId);
    }

    public Boolean rejectCustomMade(long skuCustomMadeId) {
        return this.pcsSkuCustomMadeDomain.rejectCustomMade(skuCustomMadeId);
    }
}

