/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service.impl;

import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.dao.OpProductMapper;
import com.thebeastshop.pegasus.merchandise.domain.OpProductDomain;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.service.McOpProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpProductExcelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpTagVO;
import com.thebeastshop.pegasus.merchandise.vo.OpWatermarkVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcOpProductService")
public class McOpProductServiceImpl
implements McOpProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(McOpProductServiceImpl.class);
    @Autowired
    private OpProductDomain opProductDomain;
    @Autowired
    private OpProductMapper opProductMapper;

    public boolean update(OpProductVO product) {
        return this.opProductDomain.update(product);
    }

    public OpProductVO findById(Long id) {
        return this.opProductDomain.findById(id);
    }

    public List<OpProductVO> findByIds(List<Long> ids) {
        return this.opProductDomain.findByIds(ids);
    }

    public List<Long> findProductIdsByCampaignIds(List<Long> ids) {
        return this.opProductDomain.findProductIdsByCampaignIds(ids);
    }

    public List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids) {
        return this.opProductDomain.findProdWithWatermarkByIds(ids);
    }

    public List<OpProductVO> findProdWithTagByIds(List<Long> ids) {
        return this.opProductDomain.findProdWithTagByIds(ids);
    }

    public List<Long> findProdWatermarkProdIdsByParams(Map<String, Object> params) {
        return this.opProductDomain.findProdWatermarkProdIdsByParams(params);
    }

    public List<Long> findProdTagProdIdsByParams(Map<String, Object> params) {
        return this.opProductDomain.findProdTagProdIdsByParams(params);
    }

    public List<OpProductVO> listProdMat(Map<String, Object> params) {
        List<OpProduct> list = this.opProductDomain.listProdMat(params);
        return this.opProductDomain.buildFromModelList(list);
    }

    public Long create(OpProductVO prod) {
        this.opProductDomain.create(prod);
        return prod.getId();
    }

    public Long createCombinedProduct(OpProductVO prod) {
        this.opProductDomain.createCombinedProduct(prod);
        return prod.getId();
    }

    public Boolean updateCombinedProduct(OpProductVO prod) {
        return this.opProductDomain.updateCombinedProduct(prod);
    }

    public boolean updateProdAndSku(OpProductVO productVO) {
        return this.opProductDomain.updateProdAndSku(productVO);
    }

    public boolean deleteById(Long id) {
        return this.opProductDomain.deleteById(id);
    }

    public List<OpProductVO> findByCond(OpProductCond cond) {
        return this.opProductDomain.findByCond(cond);
    }

    public List<OpProductVO> findBySkuCode(String skuCode) {
        return this.opProductDomain.findBySkuCode(skuCode);
    }

    public List<OpProductExcelVO> findExportListByCond(OpProductCond cond) {
        return this.opProductDomain.findExportListByCond(cond);
    }

    public List<OpProductVO> findByNameOrCode(String name) {
        return this.opProductDomain.findByNameOrCode(name);
    }

    public List<OpProductVO> findByIds(List<Long> ids, boolean withCategories) {
        return this.opProductDomain.findByIds(ids, withCategories);
    }

    public List<Long> findProductIdsByCodes(List<String> codes) {
        return this.opProductDomain.findProductIdsByCodes(codes);
    }

    public int updateByExampleSelective(OpProductVO vo) {
        return this.opProductDomain.updateByExampleSelective(vo);
    }

    public OpProductVO findProductByCode(String code) {
        return this.opProductDomain.findProductByCode(code);
    }

    public List<OpWatermarkVO> queryWatermarksByProdId(Map<String, Object> params) {
        return this.opProductDomain.queryWatermarksByProdId(params);
    }

    public List<OpTagVO> queryTagsByProdId(Map<String, Object> params) {
        return this.opProductDomain.queryTagsByProdId(params);
    }

    public List<Map> listProdMat(OpProductCond cond) {
        return this.opProductDomain.listProdMat(cond);
    }

    public Boolean isExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        return this.opProductDomain.isExistsSpecialCategory(productId, categoryIds);
    }

    public Boolean isOnlyExistsSpecialCategory(Long productId, List<Integer> categoryIds) {
        return this.opProductDomain.isOnlyExistsSpecialCategory(productId, categoryIds);
    }

    public Map getBatchUpdateMapByCode(String code) {
        return this.opProductMapper.getBatchUpdateMapByCode(code);
    }

    public List<OpProductVO> findProdWithSpvByNameOrCode(String arg0) {
        return this.opProductDomain.findProdWithSpvByNameOrCode(arg0);
    }

    public OpProductVO findCombinedProdbyProdId(Long prodId) {
        return this.opProductDomain.findCombinedProductByProdId(prodId);
    }

    public List<OpProductVO> findCombinedProdAuditList(OpProductCond cond) {
        return this.opProductDomain.findCombinedProdAuditList(cond);
    }

    public Boolean auditCombinedProd(OpProductCond cond) {
        return this.opProductDomain.auditCombinedProdByProdId(cond);
    }

    public Long getIdByCode(String code) {
        return this.opProductDomain.getIdByCode(code);
    }

    public String getCodeById(Long id) {
        return this.opProductDomain.getCodeById(id);
    }

    public Boolean getCrossBorderFlagListByCode(String code, Integer crossBorderFlag) {
        return this.opProductDomain.getCrossBorderFlagListByCode(code, crossBorderFlag);
    }

    public List<PcsSkuVO> getSkuListByProductCode(String productCode) {
        List<PcsSkuVO> resultList = this.opProductDomain.getSkuListByProductCode(productCode);
        return resultList;
    }
}

