/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.pegasus.merchandise.IService.IInterestGoodsService;
import com.thebeastshop.pegasus.merchandise.exception.InterestException;
import com.thebeastshop.pegasus.merchandise.exception.InterestExceptionEnum;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.scm.cond.InterestGoodsCond;
import com.thebeastshop.scm.dao.InterestGoodsDao;
import com.thebeastshop.scm.dao.InterestGoodsProvideDao;
import com.thebeastshop.scm.dao.InterestGoodsSkuDao;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.po.InterestGoodsProvide;
import com.thebeastshop.scm.po.InterestGoodsSku;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsProvideVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSaveVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.collect.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import pers.richard.ormybatis.domain.po.IdPo;

@Service
public class InterestGoodsService
implements IInterestGoodsService {
    @Resource
    private InterestGoodsDao interestGoodsDao;
    @Resource
    private InterestGoodsSkuDao interestGoodsSkuDao;
    @Resource
    private InterestGoodsProvideDao interestGoodsProvideDao;

    public List<Map> list(InterestGoodsCond cond) {
        return this.interestGoodsDao.list(cond);
    }

    public InterestGoods selectInterestById(Integer interestGoodsId) {
        return (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
    }

    public InterestGoodsVO selectInterestGoodsSku(Integer interestGoodsId) {
        InterestGoods interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
        List interestGoodsSkuList = this.interestGoodsSkuDao.byInterestGoodsId(interestGoodsId);
        return new InterestGoodsVO(interestGoods, interestGoodsSkuList);
    }

    public int sumQuantityByInterestId(Integer interestGoodsId) {
        return this.interestGoodsSkuDao.sumQuantityByInterestId(interestGoodsId);
    }

    @Transactional(value="scmDataSourceTx")
    public Integer save(InterestGoodsSaveVO vo) {
        InterestGoods interestGoods = vo.toInterestGoods();
        int res = this.interestGoodsDao.insertOrUpdate((IdPo)interestGoods);
        if (res != 1) {
            throw new InterestException(InterestExceptionEnum.ERROR_SAVE_INTEREST);
        }
        List interestGoodsSkuList = vo.toInterestGoodsSku(interestGoods.getId());
        for (InterestGoodsSku interestGoodsSku : interestGoodsSkuList) {
            res = this.interestGoodsSkuDao.insertOrUpdate((IdPo)interestGoodsSku);
            if (res == 1) continue;
            throw new InterestException(InterestExceptionEnum.ERROR_SAVE_INTEREST_SKU);
        }
        return interestGoods.getId();
    }

    @Transactional(value="scmDataSourceTx")
    public void delete(int interestGoodsId) {
        int res = this.interestGoodsDao.delete(new Number[]{interestGoodsId});
        if (res == 0) {
            throw new InterestException(InterestExceptionEnum.ERROR_DELETE_INTEREST);
        }
        res = this.interestGoodsSkuDao.deleteByInterestGoodsId(interestGoodsId);
        if (res == 0) {
            throw new InterestException(InterestExceptionEnum.ERROR_DELETE_INTEREST_SKU);
        }
    }

    public List<InterestGoodsProvideVO> getProvideRecord(InterestGoodsCond cond) {
        return this.interestGoodsProvideDao.queryProvideRecord(cond);
    }

    @Transactional(value="scmDataSourceTx")
    public InterestGoodsGetVO getInterestGoods(Integer memberId, Integer interestGoodsId) {
        if (memberId == null || interestGoodsId == null) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
        }
        InterestGoods interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
        if (interestGoods == null) {
            throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
        }
        if (interestGoods.getReceiptStartTime().after(DateUtils.getCurrentDateYMD()) || interestGoods.getReceiptEndTime().before(DateUtils.getCurrentDateYMD())) {
            throw new InterestException(InterestExceptionEnum.ERROR_RECEIVE_SPOCE);
        }
        InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInStockByInterestGoodsId(interestGoodsId);
        if (interestGoodsSku == null) {
            throw new InterestException(InterestExceptionEnum.ERROR_SKU_NO_STOCK);
        }
        boolean isSuccess = this.interestGoodsSkuDao.addReceiveQuantity(interestGoodsSku.getId());
        if (!isSuccess) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_RECEIVE);
        }
        int res = this.interestGoodsProvideDao.save(memberId, interestGoodsId, interestGoodsSku.getId());
        if (res != 1) {
            throw new InterestException(InterestExceptionEnum.ERROR_PROVIDE_INTEREST);
        }
        return new InterestGoodsGetVO(interestGoods, interestGoodsSku);
    }

    @Transactional(value="scmDataSourceTx")
    public void cash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        if (ObjectUtils.isEmpty((Object)memberId) || CollectionUtils.isEmpty(interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_NULL);
        }
        InterestGoods interestGoods = null;
        for (InterestGoodsSkuVO interestGoodsSkuVO : interestGoodsSkuVOList) {
            String skuCode;
            if (ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getCashQuantity()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getInterestGoodsId()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getSkuCode())) {
                throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
            }
            Integer interestGoodsId = interestGoodsSkuVO.getInterestGoodsId();
            InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInterestGoodsSku(interestGoodsId, skuCode = interestGoodsSkuVO.getSkuCode());
            if (ObjectUtils.isEmpty((Object)interestGoodsSku)) {
                throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND);
            }
            interestGoods = (InterestGoods)this.interestGoodsDao.selectOne((Number)interestGoodsId);
            if (interestGoods.getCashStartTime().after(DateUtils.getCurrentDateYMD()) || interestGoods.getCashEndTime().before(DateUtils.getCurrentDateYMD())) {
                throw new InterestException(InterestExceptionEnum.ERROR_CASH_SPOCE);
            }
            int unCashQuantity = this.interestGoodsProvideDao.countCashQuantity(memberId, interestGoodsId, interestGoodsSku.getId(), true);
            if (interestGoodsSkuVO.getCashQuantity() > unCashQuantity) {
                throw new InterestException(InterestExceptionEnum.ERROR_CASH_EXCESS);
            }
            interestGoodsSkuVO.setInterestGoodsSkuId(interestGoodsSku.getId());
        }
        if (!this.interestGoodsSkuDao.updateCash(interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_EXCESS);
        }
        if (!this.interestGoodsProvideDao.updateCash(memberId, interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_STATUS);
        }
    }

    @Transactional(value="scmDataSourceTx")
    public void back(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList) {
        if (ObjectUtils.isEmpty((Object)memberId) || CollectionUtils.isEmpty(interestGoodsSkuVOList)) {
            throw new InterestException(InterestExceptionEnum.ERROR_PARAM_NULL);
        }
        for (InterestGoodsSkuVO interestGoodsSkuVO : interestGoodsSkuVOList) {
            String skuCode;
            if (ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getCashQuantity()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getInterestGoodsId()) || ObjectUtils.isEmpty((Object)interestGoodsSkuVO.getSkuCode())) {
                throw new InterestException(InterestExceptionEnum.ERROR_PARAM_MISS);
            }
            Integer interestGoodsId = interestGoodsSkuVO.getInterestGoodsId();
            InterestGoodsSku interestGoodsSku = this.interestGoodsSkuDao.getInterestGoodsSku(interestGoodsId, skuCode = interestGoodsSkuVO.getSkuCode());
            if (ObjectUtils.isEmpty((Object)interestGoodsSku)) {
                throw new InterestException(InterestExceptionEnum.ERROR_NOT_FOUND.getErrCode(), String.valueOf(InterestExceptionEnum.ERROR_NOT_FOUND.getErrMsg()) + ":[" + interestGoodsSkuVO.getSkuCode() + "]");
            }
            int usedQuantity = this.interestGoodsProvideDao.countCashQuantity(memberId, interestGoodsId, interestGoodsSku.getId(), false);
            if (interestGoodsSkuVO.getCashQuantity() > usedQuantity) {
                throw new InterestException(InterestExceptionEnum.ERROR_BACK_EXCESS);
            }
            interestGoodsSkuVO.setInterestGoodsSkuId(interestGoodsSku.getId());
        }
        boolean success = this.interestGoodsProvideDao.resetCash(memberId, interestGoodsSkuVOList);
        if (!success) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_STATUS);
        }
        success = this.interestGoodsSkuDao.reduceCashQuantity(interestGoodsSkuVOList);
        if (!success) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_EXCESS);
        }
    }

    @Transactional(value="scmDataSourceTx")
    public boolean changeInterestGoodsSku(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId) {
        boolean isSuccess = this.interestGoodsSkuDao.reduceReceiveQuantity(sourceInterestGoodsSkuId);
        if (!isSuccess) {
            return false;
        }
        isSuccess = this.interestGoodsSkuDao.addReceiveQuantity(destInterestGoodsSkuId);
        if (!isSuccess) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_RECEIVE);
        }
        int res = this.interestGoodsProvideDao.changeInterestGoodsSkuId(memberId, sourceInterestGoodsSkuId, destInterestGoodsSkuId);
        if (res != 1) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_CHANGE);
        }
        return true;
    }

    public Map<Integer, Integer> getCashQuantity(List<Integer> interestGoodsSkuIds) {
        return this.interestGoodsProvideDao.getCashQuantity(interestGoodsSkuIds);
    }

    public List<InterestGoodsSku> getIdByValidity() {
        List interestGoodsList = this.interestGoodsDao.getInterestByTime(DateUtils.getCurrentDateYMD());
        ArrayList<InterestGoodsSku> result = new ArrayList<InterestGoodsSku>();
        for (InterestGoods interestGoods : interestGoodsList) {
            result.addAll(this.interestGoodsSkuDao.byInterestGoodsId(interestGoods.getId()));
        }
        return result;
    }

    public List<InterestGoodsGetVO> getPreExpiration(Integer day) {
        ArrayList InterestGoodsGetVOList = Lists.newArrayList();
        List interestGoodsList = this.interestGoodsDao.getInterestByTime(DateUtil.addDay((Date)DateUtils.getCurrentDateYMD(), (int)day));
        if (CollectionUtils.isEmpty((Collection)interestGoodsList)) {
            return InterestGoodsGetVOList;
        }
        for (InterestGoods interestGoods : interestGoodsList) {
            List interestGoodsProvideList = this.interestGoodsProvideDao.queryInterestGoodsProvide(interestGoods.getId());
            for (InterestGoodsProvide interestGoodsProvide : interestGoodsProvideList) {
                InterestGoodsSku sku = (InterestGoodsSku)this.interestGoodsSkuDao.selectOne((Number)interestGoodsProvide.getInterestGoodsSkuId());
                InterestGoodsGetVO interestGoodsGetVO = new InterestGoodsGetVO(interestGoods, sku);
                interestGoodsGetVO.setMemberId(interestGoodsProvide.getMemberId());
                InterestGoodsGetVOList.add(interestGoodsGetVO);
            }
        }
        return InterestGoodsGetVOList;
    }

    public void batchUpdateStatus(List<Integer> interestGoodsIds) {
        int res = this.interestGoodsDao.batchUpdateStatus(interestGoodsIds);
        if (res != interestGoodsIds.size()) {
            throw new InterestException(InterestExceptionEnum.ERROR_UPDATE_STATUS);
        }
    }
}

